/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.tabs.filters;

import de.uka.ipd.sdq.sensorframework.filter.FilteredCollectionRegistry;
import de.uka.ipd.sdq.sensorframework.filter.IFilteredCollectionFactory;
import de.uka.ipd.sdq.sensorframework.visualisation.VisualisationImages;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.ActionListSelectionDialog;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.AbstractReportView;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEditorInput;
import de.uka.ipd.sdq.sensorframework.visualisation.tabs.filters.FilterLabelProvider;
import de.uka.ipd.sdq.sensorframework.visualisation.tabs.filters.FiltersTabCellModifier;
import de.uka.ipd.sdq.sensorframework.visualisation.tabs.filters.FiltersTabContentProvider;
import de.uka.ipd.sdq.sensorframework.visualisation.tabs.filters.FiltersTabLabelProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class FiltersPropertySection
extends AbstractPropertySection {
    private ConfigEditorInput configObject;
    private TableViewer viewer;
    private ToolItem deleteItem;
    private ToolItem upItem;
    private ToolItem downItem;
    private IFilteredCollectionFactory selectedFactory;
    public static final int ICON_COLUMN_INDEX = 0;
    public static final int FILTERNAME_COLUMN_INDEX = 1;
    public static final int PARAMETER_TYPE_COLUMN_INDEX = 2;
    public static final int PARAMETER_DESCRIPTION_COLUMN_INDEX = 3;
    public static final int PARAMETER_VALUE_COLUMN_INDEX = 4;
    public static final String ICON_COLUMN = "";
    public static final String FILTERNAME_COLUMN = "Filter name";
    public static final String PARAMETER_TYPE_COLUMN = "Parameter type";
    public static final String PARAMETER_DESCRIPTION_COLUMN = "Description";
    public static final String PARAMETER_VALUE_COLUMN = "Value";
    private final int toolbarWidth = 23;
    protected static String[] columnNames = new String[]{"", "Filter name", "Parameter type", "Description", "Value"};
    int style = 101124;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        composite.getParent().setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(composite, this.style);
        FormData fd_table = new FormData();
        fd_table.bottom = new FormAttachment(100, 0);
        fd_table.top = new FormAttachment(0, 0);
        fd_table.left = new FormAttachment(0, 0);
        table.setLayoutData((Object)fd_table);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setColumnProperties(columnNames);
        this.viewer.setContentProvider((IContentProvider)new FiltersTabContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FiltersTabLabelProvider());
        this.viewer.setCellModifier((ICellModifier)new FiltersTabCellModifier(this));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = ((IStructuredSelection)FiltersPropertySection.this.viewer.getSelection()).getFirstElement();
                if (object instanceof IFilteredCollectionFactory) {
                    FiltersPropertySection.this.selectedFactory = (IFilteredCollectionFactory)object;
                    FiltersPropertySection.this.upItem.setEnabled(true);
                    FiltersPropertySection.this.downItem.setEnabled(true);
                    FiltersPropertySection.this.deleteItem.setEnabled(true);
                    int index = FiltersPropertySection.this.configObject.getFiltersManager().getFactories().indexOf(FiltersPropertySection.this.selectedFactory);
                    if (index == 0) {
                        FiltersPropertySection.this.upItem.setEnabled(false);
                    }
                    if (index == FiltersPropertySection.this.configObject.getFiltersManager().getFactories().size() - 1) {
                        FiltersPropertySection.this.downItem.setEnabled(false);
                    }
                }
            }
        });
        CellEditor[] editors = new CellEditor[columnNames.length];
        editors[4] = new TextCellEditor((Composite)table);
        this.viewer.setCellEditors(editors);
        TableColumn iconColumn = new TableColumn(table, 0);
        iconColumn.setWidth(30);
        iconColumn.setText(ICON_COLUMN);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setWidth(210);
        nameColumn.setText(FILTERNAME_COLUMN);
        TableColumn parametersColumn = new TableColumn(table, 0x1000000);
        parametersColumn.setWidth(100);
        parametersColumn.setText(PARAMETER_TYPE_COLUMN);
        TableColumn parameterDescColumn = new TableColumn(table, 0x1000000);
        parameterDescColumn.setWidth(140);
        parameterDescColumn.setText(PARAMETER_DESCRIPTION_COLUMN);
        TableColumn parameterValueColumn = new TableColumn(table, 0x1000000);
        parameterValueColumn.setWidth(80);
        parameterValueColumn.setText(PARAMETER_VALUE_COLUMN);
        ToolBar toolBar = new ToolBar(composite, 512);
        fd_table.right = new FormAttachment((Control)toolBar, 0, 16384);
        FormData fd_toolBar = new FormData();
        fd_toolBar.bottom = new FormAttachment(100, 0);
        fd_toolBar.left = new FormAttachment(100, -23);
        fd_toolBar.right = new FormAttachment(100, 0);
        fd_toolBar.top = new FormAttachment(0, 0);
        toolBar.setLayoutData((Object)fd_toolBar);
        ToolItem addRunItem = new ToolItem(toolBar, 8);
        addRunItem.setImage(VisualisationImages.imageRegistry.get("add_obj"));
        addRunItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IFilteredCollectionFactory factory = null;
                ActionListSelectionDialog dialog = new ActionListSelectionDialog(event.display.getActiveShell(), new FilterLabelProvider(), 250, 200);
                dialog.setElements(FiltersPropertySection.this.getDefinedFilters());
                dialog.open();
                Object[] results = dialog.getResult();
                if (results != null) {
                    factory = (IFilteredCollectionFactory)results[0];
                    FiltersPropertySection.this.configObject.getFiltersManager().addFactory(factory);
                    FiltersPropertySection.this.refresh();
                }
            }
        });
        this.upItem = new ToolItem(toolBar, 8);
        this.upItem.setImage(VisualisationImages.imageRegistry.get("up_obj"));
        this.upItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<IFilteredCollectionFactory> factories = FiltersPropertySection.this.configObject.getFiltersManager().getFactories();
                int index = factories.indexOf(FiltersPropertySection.this.selectedFactory);
                factories.remove(FiltersPropertySection.this.selectedFactory);
                factories.add(index - 1, FiltersPropertySection.this.selectedFactory);
                FiltersPropertySection.this.upItem.setEnabled(false);
                FiltersPropertySection.this.refresh();
            }
        });
        this.upItem.setEnabled(false);
        this.downItem = new ToolItem(toolBar, 8);
        this.downItem.setImage(VisualisationImages.imageRegistry.get("down_obj"));
        this.downItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<IFilteredCollectionFactory> factories = FiltersPropertySection.this.configObject.getFiltersManager().getFactories();
                int index = factories.indexOf(FiltersPropertySection.this.selectedFactory);
                factories.remove(FiltersPropertySection.this.selectedFactory);
                factories.add(index + 1, FiltersPropertySection.this.selectedFactory);
                FiltersPropertySection.this.downItem.setEnabled(false);
                FiltersPropertySection.this.refresh();
            }
        });
        this.downItem.setEnabled(false);
        this.deleteItem = new ToolItem(toolBar, 8);
        this.deleteItem.setImage(VisualisationImages.imageRegistry.get("delete_obj"));
        this.deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FiltersPropertySection.this.configObject.getFiltersManager().removeFactory(FiltersPropertySection.this.selectedFactory);
                FiltersPropertySection.this.refresh();
            }
        });
        this.deleteItem.setEnabled(false);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (part instanceof AbstractReportView) {
            AbstractReportView view = (AbstractReportView)part;
            this.configObject = (ConfigEditorInput)view.getEditorInput();
            this.viewer.setInput((Object)this.configObject);
        }
    }

    private Object[] getDefinedFilters() {
        return FilteredCollectionRegistry.singleton().getAllAvailableCollectionFactories().toArray();
    }

    public void refresh() {
        this.configObject.update(null, null);
        this.viewer.refresh();
    }
}

