/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.views;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;

public class TreeObject {
    private final Object object;
    private final IDAOFactory datasource;
    private final Experiment experiment;
    private final ExperimentRun run;
    private final boolean isEmpty;

    public TreeObject(Object object, IDAOFactory datasource, Experiment experiment) {
        this.datasource = datasource;
        this.object = object;
        this.experiment = experiment;
        this.run = null;
        this.isEmpty = true;
    }

    public TreeObject(Sensor sensor, IDAOFactory datasource, Experiment experiment, ExperimentRun run) {
        this.datasource = datasource;
        this.object = sensor;
        this.experiment = experiment;
        this.run = run;
        this.isEmpty = run.getMeasurementsOfSensor(sensor).getMeasurements().isEmpty();
    }

    public Object getObject() {
        return this.object;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public ExperimentRun getRun() {
        return this.run;
    }

    public IDAOFactory getDatasource() {
        return this.datasource;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }
}

