/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.dialogs;

import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.ExperimentRunsDialogContentProvider;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeLabelProvider;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeObject;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ExperimentRunsDialog
extends TitleAreaDialog {
    private TreeObject selectedObject = null;
    private Label selectedField;
    private Button okButton;
    private Button cancelButton;

    public ExperimentRunsDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(1104);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Run");
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ExperimentRunsDialog.this.selectedObject = null;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FormLayout());
        container.setLayoutData((Object)new GridData(1808));
        TreeViewer viewer = new TreeViewer(container, 2048);
        Tree tree = viewer.getTree();
        FormData fd_tree = new FormData();
        fd_tree.bottom = new FormAttachment(100, -50);
        fd_tree.right = new FormAttachment(100, -5);
        fd_tree.top = new FormAttachment(0, 5);
        fd_tree.left = new FormAttachment(0, 5);
        tree.setLayoutData((Object)fd_tree);
        viewer.setContentProvider((IContentProvider)new ExperimentRunsDialogContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        viewer.setInput(new ArrayList());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object objeckt = sel.getFirstElement();
                if (objeckt instanceof TreeObject) {
                    ExperimentRunsDialog.this.selectedObject = (TreeObject)objeckt;
                    ExperimentRunsDialog.this.setSelectedField(ExperimentRunsDialog.this.selectedObject);
                    ExperimentRunsDialog.this.okButton.setEnabled(true);
                } else {
                    ExperimentRunsDialog.this.okButton.setEnabled(false);
                }
            }
        });
        Label selectedRunLabel = new Label(container, 0);
        FormData fd_selectedRunLabel = new FormData();
        fd_selectedRunLabel.top = new FormAttachment((Control)tree, 10, -1);
        fd_selectedRunLabel.bottom = new FormAttachment(100, -20);
        fd_selectedRunLabel.left = new FormAttachment(0, 10);
        selectedRunLabel.setLayoutData((Object)fd_selectedRunLabel);
        GridLayout labelLayout = new GridLayout();
        labelLayout.numColumns = 2;
        selectedRunLabel.setText("Selected Run:");
        this.selectedField = new Label(container, 0);
        fd_selectedRunLabel.right = new FormAttachment((Control)this.selectedField, -5, 16384);
        FormData fd_label = new FormData();
        fd_label.top = new FormAttachment((Control)tree, 10, -1);
        fd_label.bottom = new FormAttachment(100, -27);
        fd_label.left = new FormAttachment(0, 95);
        fd_label.right = new FormAttachment((Control)tree, 0, 131072);
        this.selectedField.setLayoutData((Object)fd_label);
        this.selectedField.setText("...");
        Label separator = new Label(container, 258);
        FormData fd_separator = new FormData();
        fd_separator.top = new FormAttachment((Control)this.selectedField, 12, -1);
        fd_separator.left = new FormAttachment(0, 5);
        fd_separator.right = new FormAttachment(100, -5);
        fd_separator.bottom = new FormAttachment(100, -5);
        separator.setLayoutData((Object)fd_separator);
        this.setMessage("Select you run...");
        return area;
    }

    private void setSelectedField(TreeObject treeObject) {
        ExperimentRun run = (ExperimentRun)treeObject.getObject();
        if (this.selectedField != null) {
            this.selectedField.setText(run.getExperimentDateTime());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExperimentRunsDialog.this.selectedObject = null;
            }
        });
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
    }

    protected Point getInitialSize() {
        return new Point(397, 372);
    }

    public TreeObject getResult() {
        return this.selectedObject;
    }
}

