/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.adapter.AdapterRegistry;
import de.uka.ipd.sdq.sensorframework.adapter.IAdapterFactory;
import de.uka.ipd.sdq.sensorframework.dao.memory.MemoryDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.filter.FilteredCollectionRegistry;
import de.uka.ipd.sdq.sensorframework.filter.IFilteredCollectionFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class SensorFrameworkPluginActivator
extends Plugin {
    public static final String PLUGIN_ID = "de.uka.ipd.sdq.sensorframework";
    private static final String ADAPTER_EPID = "de.uka.ipd.sdq.sensorframework.adapter";
    private static final String FILTER_EPID = "de.uka.ipd.sdq.sensorframework.filter";
    private static SensorFrameworkPluginActivator plugin;

    public void start(BundleContext context) throws Exception {
        block7: {
            Object factory;
            IConfigurationElement configurationElement;
            super.start(context);
            plugin = this;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(ADAPTER_EPID);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                configurationElement = iConfigurationElementArray[n2];
                factory = (IAdapterFactory)configurationElement.createExecutableExtension("class");
                AdapterRegistry.singleton().addAdapterFactory((IAdapterFactory)factory);
                ++n2;
            }
            iConfigurationElementArray = registry.getConfigurationElementsFor(FILTER_EPID);
            n = iConfigurationElementArray.length;
            n2 = 0;
            while (n2 < n) {
                configurationElement = iConfigurationElementArray[n2];
                factory = (IFilteredCollectionFactory)configurationElement.createExecutableExtension("class");
                String filterName = configurationElement.getAttribute("displayName");
                FilteredCollectionRegistry.singleton().addFilteredCollectionFactory(filterName, (IFilteredCollectionFactory)factory);
                ++n2;
            }
            try {
                File file = context.getDataFile(PLUGIN_ID);
                FileInputStream fis = new FileInputStream(file);
                DataInputStream dos = new DataInputStream(fis);
                while (fis.available() > 0) {
                    long id = dos.readLong();
                    String className = dos.readUTF();
                    String config = dos.readUTF();
                    IDAOFactory factory2 = (IDAOFactory)Class.forName(className).getConstructor(String.class).newInstance(config);
                    factory2.setID((int)id);
                    SensorFrameworkDataset.singleton().addDataSource(factory2);
                }
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException) {
                    SensorFrameworkPluginActivator.log(1, "No preexisting dataset configuration file. Resetting configuration...", null);
                } else {
                    SensorFrameworkPluginActivator.log(2, "Restoring Dataset Configuration failed. Resetting configuration...", e);
                }
                if (SensorFrameworkDataset.singleton().getDataSources().size() != 0) break block7;
                SensorFrameworkDataset.singleton().addDataSource(new MemoryDAOFactory(0L));
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        File f = context.getDataFile(PLUGIN_ID);
        try {
            f.delete();
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(f));
            Collection<IDAOFactory> sources = SensorFrameworkDataset.singleton().getDataSources();
            for (IDAOFactory source : sources) {
                try {
                    source.finalizeAndClose();
                }
                catch (Exception e) {
                    SensorFrameworkPluginActivator.log(4, "Failed to close datasource with ID " + source.getID(), e);
                }
                dos.writeLong(source.getID());
                dos.writeUTF(source.getClass().getName());
                dos.writeUTF(source.getPersistendInfo());
            }
            dos.close();
        }
        catch (Exception e) {
            SensorFrameworkPluginActivator.log(4, "Saving Dataset Configuration failed.", e);
            f.deleteOnExit();
        }
        super.stop(context);
    }

    public static SensorFrameworkPluginActivator getDefault() {
        return plugin;
    }

    public static void log(int severity, String message, Throwable t) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message, t));
        }
    }
}

