/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.memory;

import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.IStateDAO;
import de.uka.ipd.sdq.sensorframework.entities.impl.StateImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class MemoryStateDAO
implements IStateDAO {
    private long nextID = 0L;
    private final IDAOFactory myFactory;
    private final HashMap<Long, State> index = new HashMap();

    public MemoryStateDAO(IDAOFactory myFactory) {
        this.myFactory = myFactory;
    }

    @Override
    public synchronized State addState(String p_stateliteral) {
        StateImpl result = new StateImpl(this.myFactory);
        result.setStateID(this.nextID++);
        result.setStateLiteral(p_stateliteral);
        this.index.put(result.getStateID(), result);
        return result;
    }

    @Override
    public synchronized State get(long id) {
        return this.index.get(id);
    }

    @Override
    public synchronized Collection<State> getStates() {
        return Collections.unmodifiableCollection(this.index.values());
    }

    @Override
    public synchronized Collection<State> findByStateLiteral(String searchKey) {
        ArrayList<State> result = new ArrayList<State>();
        for (State e : this.index.values()) {
            if (!e.getStateLiteral().equals(searchKey)) continue;
            result.add(e);
        }
        return Collections.unmodifiableCollection(result);
    }

    public void store(StateSensor stateSen) {
    }

    @Override
    public synchronized void removeState(State state, boolean doCascade) {
        if (state == null) {
            return;
        }
        this.index.remove(state.getStateID());
    }

    public void store(State st) {
    }

    @Override
    public void storeAll() {
    }
}

