/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file;

import de.uka.ipd.sdq.sensorframework.dao.file.AbstractFileDAO;
import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.dao.file.IDGenerator;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.ScalabilitySensorImpl;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.StateSensorImpl;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.TimeSpanSensorImpl;
import de.uka.ipd.sdq.sensorframework.entities.ScalabilitySensor;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.ISensorDAO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class FileSensorDAO
extends AbstractFileDAO<Sensor>
implements ISensorDAO {
    public FileSensorDAO(FileDAOFactory factory, IDGenerator idGen) {
        super(factory, idGen, "sensor");
    }

    @Override
    public StateSensor addStateSensor(State p_initialstate, String p_sensorname) {
        StateSensorImpl stsen = new StateSensorImpl(this.factory);
        stsen.setInitialState(p_initialstate);
        stsen.setSensorName(p_sensorname);
        stsen.setSensorID(this.idGen.getNextSensorID());
        this.putEntity(stsen);
        return stsen;
    }

    @Override
    public TimeSpanSensor addTimeSpanSensor(String p_sensorname) {
        TimeSpanSensorImpl result = new TimeSpanSensorImpl(this.factory);
        result.setSensorID(this.idGen.getNextSensorID());
        result.setSensorName(p_sensorname);
        this.putEntity(result);
        return result;
    }

    @Override
    public ScalabilitySensor addScalabilitySensor(String p_sensorname) {
        ScalabilitySensorImpl result = new ScalabilitySensorImpl(this.factory);
        result.setSensorID(this.idGen.getNextSensorID());
        result.setSensorName(p_sensorname);
        this.putEntity(result);
        return result;
    }

    @Override
    public Collection<Sensor> findBySensorName(String searchKey) {
        ArrayList<Sensor> result = new ArrayList<Sensor>();
        for (Sensor sen : this.getAllEntities()) {
            if (!sen.getSensorName().equals(searchKey)) continue;
            result.add(sen);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Collection<Sensor> getSensors() {
        return this.getAllEntities();
    }

    @Override
    public void removeSensor(Sensor sensor, boolean doCascade) {
        this.removeEntity(sensor, doCascade);
    }
}

