/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file.entities;

import de.uka.ipd.sdq.sensorframework.entities.ScalabilitySensor;
import de.uka.ipd.sdq.sensorframework.storage.lists.ISerialiser;

public class ParameterValueSerialiser
implements ISerialiser {
    private int nbParameters = 1;

    public ParameterValueSerialiser(ScalabilitySensor sSensor) {
    }

    public Object[] deserialise(byte[] bytes) {
        if (bytes.length < 4) {
            return new Double[0][0];
        }
        int blockPos = 0;
        int nb = 0;
        int i = 3;
        while (i >= 0) {
            nb <<= 4;
            nb |= bytes[blockPos + i] < 0 ? 256 + bytes[blockPos + i] : bytes[blockPos + i];
            --i;
        }
        blockPos += 4;
        this.nbParameters = nb;
        Double[][] values = new Double[(int)((long)(bytes.length - 4) / this.getElementLength())][this.nbParameters];
        int j = 0;
        while (j < values.length) {
            int k = 0;
            while (k < this.nbParameters) {
                long l = 0L;
                int i2 = 7;
                while (i2 >= 0) {
                    l <<= 8;
                    l |= (long)(bytes[blockPos + i2] < 0 ? 256 + bytes[blockPos + i2] : bytes[blockPos + i2]);
                    --i2;
                }
                blockPos += 8;
                values[j][k] = l;
                ++k;
            }
            ++j;
        }
        return values;
    }

    public long getElementLength() {
        return 8 * this.nbParameters;
    }

    public byte[] serialise(Object[] objects, int count) {
        if (count > 0) {
            this.nbParameters = ((Double[])objects[0]).length;
        }
        byte[] block = new byte[(int)((long)count * this.getElementLength() + 4L)];
        int blockPos = 0;
        int nb = this.nbParameters;
        int i = 0;
        while (i < 4) {
            block[blockPos++] = (byte)(nb & 0xFF);
            nb >>= 4;
            ++i;
        }
        int j = 0;
        while (j < count) {
            Double[] serie = (Double[])objects[j];
            int k = 0;
            while (k < this.nbParameters) {
                long l = serie[k].longValue();
                int i2 = 0;
                while (i2 < 8) {
                    block[blockPos++] = (byte)(l & 0xFFL);
                    l >>= 8;
                    ++i2;
                }
                ++k;
            }
            ++j;
        }
        return block;
    }
}

