/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.adapter;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.AbstractPie;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.TimeDeltaPie;
import de.uka.ipd.sdq.sensorframework.adapter.StateSensorToPieAdapter;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import java.util.HashMap;

public class StateSensorToTimeDeltaPieAdapter
extends StateSensorToPieAdapter {
    public StateSensorToTimeDeltaPieAdapter(SensorAndMeasurements samInformation) {
        super(samInformation);
    }

    @Override
    protected double calculateFractions(HashMap<String, Double> fractions) {
        for (State state : ((StateSensor)this.samInformation.getSensor()).getSensorStates()) {
            fractions.put(state.getStateLiteral(), 0.0);
        }
        double lastChangeTime = 0.0;
        State lastState = ((StateSensor)this.samInformation.getSensor()).getInitialState();
        double sum = 0.0;
        for (Measurement m : this.samInformation.getMeasurements()) {
            StateMeasurement sm = (StateMeasurement)m;
            double oldValue = fractions.get(lastState.getStateLiteral());
            double diff = sm.getEventTime() - lastChangeTime;
            double newValue = oldValue + diff;
            sum += diff;
            fractions.put(lastState.getStateLiteral(), newValue);
            lastChangeTime = sm.getEventTime();
            lastState = sm.getSensorState();
        }
        return sum;
    }

    @Override
    protected AbstractPie instantiatePie(String sensorName) {
        return new TimeDeltaPie(sensorName);
    }
}

