/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.memory;

import de.uka.ipd.sdq.sensorframework.dao.memory.MemoryDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentDAO;
import de.uka.ipd.sdq.sensorframework.entities.impl.ExperimentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class MemoryExperimentDAO
implements IExperimentDAO {
    private long nextID = 0L;
    private final HashMap<Long, Experiment> index = new HashMap();
    private final MemoryDAOFactory factory;

    public MemoryExperimentDAO(MemoryDAOFactory memoryDAOFactory) {
        this.factory = memoryDAOFactory;
    }

    @Override
    public synchronized Experiment addExperiment(String p_experimentname) {
        ExperimentImpl result = new ExperimentImpl(this.factory);
        result.setExperimentID(this.nextID++);
        result.setExperimentName(p_experimentname);
        this.index.put(result.getExperimentID(), result);
        return result;
    }

    @Override
    public synchronized Experiment get(long id) {
        return this.index.get(id);
    }

    @Override
    public synchronized Collection<Experiment> getExperiments() {
        return Collections.unmodifiableCollection(this.index.values());
    }

    @Override
    public synchronized Collection<Experiment> findByExperimentName(String searchKey) {
        ArrayList<Experiment> result = new ArrayList<Experiment>();
        for (Experiment e : this.index.values()) {
            if (!e.getExperimentName().equals(searchKey)) continue;
            result.add(e);
        }
        return Collections.unmodifiableCollection(result);
    }

    public void store(Experiment e) {
    }

    @Override
    public synchronized void removeExperiment(Experiment experiment, boolean doCascade) {
        if (experiment == null) {
            return;
        }
        if (doCascade) {
            for (ExperimentRun expRun : experiment.getExperimentRuns()) {
                this.factory.createExperimentRunDAO().removeExperimentRun(expRun, true);
            }
            for (Sensor sensor : experiment.getSensors()) {
                this.factory.createSensorDAO().removeSensor(sensor, true);
            }
        }
        this.index.remove(experiment.getExperimentID());
    }

    @Override
    public void storeAll() {
    }
}

