/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.tabs.sensors;

import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.visualisation.VisualisationImages;
import de.uka.ipd.sdq.sensorframework.visualisation.VisualisationPlugin;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.ExperimentRunsDialog;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.SensorsDialog;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.AbstractReportView;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEditorInput;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEntry;
import de.uka.ipd.sdq.sensorframework.visualisation.tabs.sensors.SensorsTabCellModifier;
import de.uka.ipd.sdq.sensorframework.visualisation.tabs.sensors.SensorsTabContentProvider;
import de.uka.ipd.sdq.sensorframework.visualisation.tabs.sensors.SensorsTabLabelProvider;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeObject;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SensorsPropertySection
extends AbstractPropertySection
implements Observer {
    private ConfigEditorInput configObject;
    private ConfigEntry selectedEntry;
    private TableViewer viewer;
    private ToolItem deleteRunItem;
    public static final int ICON_COLUMN_INDEX = 0;
    public static final int CONTEXT_COLUMN_INDEX = 1;
    public static final int RUN_COLUMN_INDEX = 2;
    public static final int SENSORS_COLUMN_INDEX = 3;
    public static final String ICON_COLUMN = "";
    public static final String CONTEXT_COLUMN = "Context";
    public static final String RUN_COLUMN = "Experiment Datetime";
    public static final String SENSORS_COLUMN = "Sensors";
    private final int toolbarWidth = 24;
    protected static String[] columnNames = new String[]{"", "Context", "Experiment Datetime", "Sensors"};
    int style = 101124;

    @Override
    public void update(Observable subject, Object signal) {
        if (subject instanceof ConfigEditorInput) {
            this.refresh();
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        composite.getParent().setLayoutData((Object)new GridData(4, 4, true, true));
        CellEditor[] editors = new CellEditor[columnNames.length];
        Table table = new Table(composite, this.style);
        FormData fd_table = new FormData();
        fd_table.bottom = new FormAttachment(100, 0);
        fd_table.left = new FormAttachment(0, 0);
        fd_table.top = new FormAttachment(0, 0);
        table.setLayoutData((Object)fd_table);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setColumnProperties(columnNames);
        this.viewer.setContentProvider((IContentProvider)new SensorsTabContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SensorsTabLabelProvider());
        this.viewer.setCellModifier((ICellModifier)new SensorsTabCellModifier());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = ((IStructuredSelection)SensorsPropertySection.this.viewer.getSelection()).getFirstElement();
                SensorsPropertySection.this.selectedEntry = (ConfigEntry)object;
                if (SensorsPropertySection.this.selectedEntry != null) {
                    SensorsPropertySection.this.deleteRunItem.setEnabled(true);
                } else {
                    SensorsPropertySection.this.deleteRunItem.setEnabled(false);
                }
            }
        });
        editors[3] = new DialogCellEditor((Composite)table){

            protected Object openDialogBox(Control cellEditorWindow) {
                SensorsDialog dialog = new SensorsDialog(cellEditorWindow.getShell(), SensorsPropertySection.this.selectedEntry);
                if (dialog.open() == 0) {
                    SensorsPropertySection.this.viewer.refresh();
                }
                return null;
            }
        };
        this.viewer.setCellEditors(editors);
        TableColumn zeroColumn = new TableColumn(table, 0);
        zeroColumn.setResizable(false);
        zeroColumn.setWidth(30);
        TableColumn contextColumn = new TableColumn(table, 0);
        contextColumn.setWidth(100);
        contextColumn.setText(CONTEXT_COLUMN);
        TableColumn runColumn = new TableColumn(table, 0);
        runColumn.setWidth(140);
        runColumn.setText(RUN_COLUMN);
        TableColumn sensorsColumn = new TableColumn(table, 0);
        sensorsColumn.setWidth(200);
        sensorsColumn.setText(SENSORS_COLUMN);
        ToolBar toolBar = new ToolBar(composite, 512);
        fd_table.right = new FormAttachment((Control)toolBar, 0, 16384);
        FormData fd_toolBar = new FormData();
        fd_toolBar.left = new FormAttachment(100, -24);
        fd_toolBar.bottom = new FormAttachment(100, 0);
        fd_toolBar.right = new FormAttachment(100, 0);
        fd_toolBar.top = new FormAttachment(0, 0);
        toolBar.setLayoutData((Object)fd_toolBar);
        ToolItem addRunItem = new ToolItem(toolBar, 8);
        addRunItem.setImage(VisualisationImages.imageRegistry.get("add_obj"));
        addRunItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExperimentRunsDialog dialog = new ExperimentRunsDialog(e.display.getActiveShell());
                if (dialog.open() == 0 && dialog.getResult() != null) {
                    TreeObject object = dialog.getResult();
                    ConfigEntry configEntry = new ConfigEntry(object.getDatasource(), (ExperimentRun)object.getObject(), object.getExperiment(), null);
                    SensorsPropertySection.this.configObject.addConfigEntry(configEntry);
                    SensorsPropertySection.this.viewer.refresh();
                }
            }
        });
        this.deleteRunItem = new ToolItem(toolBar, 8);
        this.deleteRunItem.setImage(VisualisationImages.imageRegistry.get("delete_obj"));
        this.deleteRunItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SensorsPropertySection.this.configObject.removeConfigEntry(SensorsPropertySection.this.selectedEntry);
            }
        });
        this.deleteRunItem.setEnabled(false);
        AbstractReportView view = (AbstractReportView)VisualisationPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.configObject = (ConfigEditorInput)view.getEditorInput();
        this.configObject.addObserver(this);
    }

    public ISelection getSelection() {
        return super.getSelection();
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (part instanceof AbstractReportView) {
            AbstractReportView view = (AbstractReportView)part;
            this.configObject = (ConfigEditorInput)view.getEditorInput();
            this.viewer.setInput((Object)this.configObject);
        }
    }
}

