/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file.entities;

import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.SensorImpl;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class StateSensorImpl
extends SensorImpl
implements StateSensor {
    private static final long serialVersionUID = -1981199624361875277L;
    private Long initialStateID;
    private final ArrayList<Long> sensorStateIDs = new ArrayList();

    public StateSensorImpl(FileDAOFactory factory) {
        super(factory);
    }

    @Override
    public void addSensorState(State value) {
        this.sensorStateIDs.add(value.getStateID());
    }

    @Override
    public State addState(String p_stateliteral) {
        State state = this.factory.createStateDAO().addState(p_stateliteral);
        this.sensorStateIDs.add(state.getStateID());
        return state;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StateSensorImpl)) {
            return false;
        }
        StateSensorImpl s = (StateSensorImpl)obj;
        return this.sensorID == s.getSensorID() && this.sensorName.equals(s.getSensorName());
    }

    @Override
    public State getInitialState() {
        return this.factory.createStateDAO().get(this.initialStateID);
    }

    @Override
    public Collection<State> getSensorStates() {
        ArrayList<State> result = new ArrayList<State>();
        for (Long id : this.sensorStateIDs) {
            result.add(this.factory.createStateDAO().get(id));
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public void setInitialState(State value) {
        this.initialStateID = value.getStateID();
    }
}

