/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.memory;

import de.uka.ipd.sdq.sensorframework.dao.memory.MemoryExperimentDAO;
import de.uka.ipd.sdq.sensorframework.dao.memory.MemoryExperimentRunDAO;
import de.uka.ipd.sdq.sensorframework.dao.memory.MemoryMeasurementDAO;
import de.uka.ipd.sdq.sensorframework.dao.memory.MemorySensorDAO;
import de.uka.ipd.sdq.sensorframework.dao.memory.MemoryStateDAO;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentDAO;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentRunDAO;
import de.uka.ipd.sdq.sensorframework.entities.dao.IMeasurementDAO;
import de.uka.ipd.sdq.sensorframework.entities.dao.ISensorDAO;
import de.uka.ipd.sdq.sensorframework.entities.dao.IStateDAO;

public class MemoryDAOFactory
implements IDAOFactory {
    private IExperimentDAO experimentDAO;
    private IExperimentRunDAO experimentRunDAO;
    private IMeasurementDAO measurementDAO;
    private ISensorDAO sensorDAO;
    private IStateDAO stateDAO;
    private long id;

    public MemoryDAOFactory(long id) {
        this.id = id;
    }

    public MemoryDAOFactory(String config) {
        this(-1L);
    }

    @Override
    public IExperimentDAO createExperimentDAO() {
        if (this.experimentDAO == null) {
            this.experimentDAO = new MemoryExperimentDAO(this);
        }
        return this.experimentDAO;
    }

    @Override
    public IExperimentRunDAO createExperimentRunDAO() {
        if (this.experimentRunDAO == null) {
            this.experimentRunDAO = new MemoryExperimentRunDAO(this);
        }
        return this.experimentRunDAO;
    }

    @Override
    public IMeasurementDAO createMeasurementDAO() {
        if (this.measurementDAO == null) {
            this.measurementDAO = new MemoryMeasurementDAO(this);
        }
        return this.measurementDAO;
    }

    @Override
    public ISensorDAO createSensorDAO() {
        if (this.sensorDAO == null) {
            this.sensorDAO = new MemorySensorDAO(this);
        }
        return this.sensorDAO;
    }

    @Override
    public IStateDAO createStateDAO() {
        if (this.stateDAO == null) {
            this.stateDAO = new MemoryStateDAO(this);
        }
        return this.stateDAO;
    }

    @Override
    public String getDescription() {
        return "A datasource stored in memory. Changes are lost, when unsafed";
    }

    @Override
    public String getName() {
        return "Memory Datasource";
    }

    @Override
    public void finalizeAndClose() {
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public void setID(long i) {
        this.id = i;
    }

    @Override
    public String getPersistendInfo() {
        return "";
    }

    @Override
    public void reload() {
    }

    @Override
    public void store() {
    }
}

