/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.services;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.palladiosimulator.retriever.services.Service;

public interface Discoverer
extends Service {
    public static Stream<Path> find(Path root, String suffix, Logger logger) {
        Path normalizedRoot = Objects.requireNonNull(root).toAbsolutePath().normalize();
        String normalizedSuffix = Objects.requireNonNull(suffix).toLowerCase().strip();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Stream<Path> walk = Files.walk(normalizedRoot, new FileVisitOption[0]);){
                return walk.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().toLowerCase().endsWith(normalizedSuffix)).map(Path::toAbsolutePath).map(Path::normalize).distinct().collect(Collectors.toSet()).stream();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | SecurityException e) {
            logger.error((Object)String.format("No %s files could be found in %s", normalizedSuffix, normalizedRoot), (Throwable)e);
            return Stream.empty();
        }
    }

    @Override
    default public Set<String> getRequiredServices() {
        return Set.of();
    }

    @Override
    default public Set<String> getDependentServices() {
        return Set.of();
    }
}

