/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.apache.impl;

import de.uka.ipd.sdq.probfunction.math.IBinomialDistribution;
import de.uka.ipd.sdq.probfunction.math.IChiSquareDistribution;
import de.uka.ipd.sdq.probfunction.math.IExponentialDistribution;
import de.uka.ipd.sdq.probfunction.math.IGammaDistribution;
import de.uka.ipd.sdq.probfunction.math.ILognormalDistribution;
import de.uka.ipd.sdq.probfunction.math.INormalDistribution;
import de.uka.ipd.sdq.probfunction.math.IPDFFactory;
import de.uka.ipd.sdq.probfunction.math.IPoissonDistribution;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.IStudentTDistribution;
import de.uka.ipd.sdq.probfunction.math.IUniformDistribution;
import de.uka.ipd.sdq.probfunction.math.IUniformIntDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.BinomialDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.ChiSquareDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.ExponentialDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.GammaDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.GammaDistributionFromMoments;
import de.uka.ipd.sdq.probfunction.math.apache.impl.LognormalDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.LognormalDistributionFromMoments;
import de.uka.ipd.sdq.probfunction.math.apache.impl.NormalDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.PoissonDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.StudentTDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.UniformDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.UniformIntDistribution;
import de.uka.ipd.sdq.probfunction.math.impl.DefaultRandomGenerator;

public class PDFFactory
implements IPDFFactory {
    private IRandomGenerator rng = new DefaultRandomGenerator();

    @Override
    public void setRandomGenerator(IRandomGenerator randomGenerator) {
        this.rng = randomGenerator;
    }

    @Override
    public IExponentialDistribution createExponentialDistribution(double rate) {
        return new ExponentialDistribution(rate, this.rng);
    }

    @Override
    public IGammaDistribution createGammaDistribution(double alpha, double theta) {
        return new GammaDistribution(alpha, theta, this.rng);
    }

    @Override
    public ILognormalDistribution createLognormalDistribution(double mu, double sigma) {
        return new LognormalDistribution(mu, sigma, this.rng);
    }

    @Override
    public INormalDistribution createNormalDistribution(double mu, double sigma) {
        return new NormalDistribution(mu, sigma, this.rng);
    }

    @Override
    public IGammaDistribution createGammaDistributionFromMoments(double mean, double coeffVar) {
        return new GammaDistributionFromMoments(mean, coeffVar, this.rng);
    }

    @Override
    public ILognormalDistribution createLognormalDistributionFromMoments(double mean, double variance) {
        return new LognormalDistributionFromMoments(mean, variance, this.rng);
    }

    @Override
    public IBinomialDistribution createBinomialDistribution(int trials, double probability) {
        return new BinomialDistribution(trials, probability);
    }

    @Override
    public IPoissonDistribution createPoissonDistribution(double mean) {
        return new PoissonDistribution(mean);
    }

    @Override
    public IUniformIntDistribution createUniformIntDistribution(int a, int b) {
        return new UniformIntDistribution(a, b);
    }

    @Override
    public IUniformDistribution createUniformDistribution(double a, double b) {
        return new UniformDistribution(a, b, this.rng);
    }

    @Override
    public IChiSquareDistribution createChiSquareDistribution(int degreesOfFreedom) {
        return new ChiSquareDistribution(degreesOfFreedom, this.rng);
    }

    @Override
    public IStudentTDistribution createStudentTDistribution(int degreesOfFreedom) {
        return new StudentTDistribution(degreesOfFreedom, this.rng);
    }
}

