/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.apache.distribution;

import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistribution;
import org.apache.commons.math.distribution.NormalDistributionImpl;

public class LognormalDistributionImpl
extends NormalDistributionImpl
implements NormalDistribution {
    private static final long serialVersionUID = -4630735663414796584L;

    public LognormalDistributionImpl(double mu, double sigma) {
        super(mu, sigma);
    }

    public double cumulativeProbability(double x) throws MathException {
        if (x == 0.0) {
            return 0.0;
        }
        return super.cumulativeProbability(Math.log(x));
    }

    public double cumulativeProbability(double x0, double x1) throws MathException {
        return super.cumulativeProbability(Math.log(x0), Math.log(x1));
    }

    public double getMean() {
        return super.getMean();
    }

    public double density(double x) {
        return super.density(Math.log(x)) / x;
    }

    public double getStandardDeviation() {
        return super.getStandardDeviation();
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        return super.inverseCumulativeProbability(p);
    }

    protected double getInitialDomain(double p) {
        return Math.exp(super.getInitialDomain(p));
    }

    protected double getDomainLowerBound(double p) {
        return Math.exp(super.getDomainLowerBound(p));
    }

    protected double getDomainUpperBound(double p) {
        return Math.exp(super.getDomainUpperBound(p));
    }
}

