/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.apache.distribution;

import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;

public class UniformDistributionImpl
extends AbstractContinuousDistribution {
    private static final long serialVersionUID = 4771624459254238355L;
    double a;
    double b;

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public UniformDistributionImpl(double a, double b) throws MathException {
        if (b < a) {
            throw new MathException("Second value has to be greater than first value of interval", new Object[0]);
        }
        this.a = a;
        this.b = b;
    }

    public double cumulativeProbability(double x) throws MathException {
        if (x < this.a) {
            return 0.0;
        }
        if (x > this.b) {
            return 1.0;
        }
        return (x - this.a) / (this.b - this.a);
    }

    protected double getDomainLowerBound(double p) {
        return this.a;
    }

    protected double getDomainUpperBound(double p) {
        return this.b;
    }

    public double getMean() {
        return (this.a + this.b) / 2.0;
    }

    public double getVariance() {
        return 0.08333333333333333 * (this.b - this.a) * (this.b - this.a);
    }

    protected double getInitialDomain(double p) {
        return this.getMean();
    }
}

