/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.apache.impl;

import de.uka.ipd.sdq.probfunction.math.IBinomialDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.AbstractDiscretePDF;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.UnorderedDomainException;
import org.apache.commons.math.distribution.BinomialDistributionImpl;

public class BinomialDistribution
extends AbstractDiscretePDF
implements IBinomialDistribution {
    public BinomialDistribution(int trials, double p) {
        this.internalFunction = new BinomialDistributionImpl(trials, p);
    }

    @Override
    public double getStandardDeviation() {
        int n = ((BinomialDistributionImpl)this.internalFunction).getNumberOfTrials();
        double p = ((BinomialDistributionImpl)this.internalFunction).getProbabilityOfSuccess();
        return Math.sqrt((double)n * p * (1.0 - p));
    }

    @Override
    public double getXinf() {
        return 0.0;
    }

    @Override
    public double getXsup() {
        return ((BinomialDistributionImpl)this.internalFunction).getNumberOfTrials();
    }

    @Override
    public double getArithmeticMeanValue() throws DomainNotNumbersException, FunctionNotInTimeDomainException {
        return this.getMean();
    }

    @Override
    public Object getMedian() throws UnorderedDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getPercentile(int p) throws IndexOutOfBoundsException, UnorderedDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasOrderedDomain() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getLowerDomainBorder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getMean() {
        int n = ((BinomialDistributionImpl)this.internalFunction).getNumberOfTrials();
        double p = ((BinomialDistributionImpl)this.internalFunction).getProbabilityOfSuccess();
        return (double)n * p;
    }

    @Override
    public double getProbability() {
        return ((BinomialDistributionImpl)this.internalFunction).getProbabilityOfSuccess();
    }

    @Override
    public int getTrials() {
        return ((BinomialDistributionImpl)this.internalFunction).getNumberOfTrials();
    }
}

