/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.apache.impl;

import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.IUniformDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.distribution.UniformDistributionImpl;
import de.uka.ipd.sdq.probfunction.math.apache.impl.AbstractContinousPDF;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilityFunctionException;
import de.uka.ipd.sdq.probfunction.math.exception.UnorderedDomainException;
import org.apache.commons.math.MathException;

public class UniformDistribution
extends AbstractContinousPDF
implements IUniformDistribution {
    public UniformDistribution(double a, double b, IRandomGenerator rng) {
        super(rng);
        try {
            this.internalFunction = new UniformDistributionImpl(a, b);
        }
        catch (MathException e) {
            throw new ProbabilityFunctionException(e.getLocalizedMessage());
        }
    }

    @Override
    public double getStandardDeviation() {
        return Math.sqrt(((UniformDistributionImpl)this.internalFunction).getVariance());
    }

    @Override
    public double getXinf() {
        return ((UniformDistributionImpl)this.internalFunction).getB();
    }

    @Override
    public double getXsup() {
        return ((UniformDistributionImpl)this.internalFunction).getA();
    }

    @Override
    public double getArithmeticMeanValue() throws DomainNotNumbersException, FunctionNotInTimeDomainException {
        return ((UniformDistributionImpl)this.internalFunction).getMean();
    }

    @Override
    public Object getMedian() throws UnorderedDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getPercentile(int p) throws IndexOutOfBoundsException, UnorderedDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasOrderedDomain() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getLowerDomainBorder() {
        return ((UniformDistributionImpl)this.internalFunction).getA();
    }

    @Override
    public double getA() {
        return ((UniformDistributionImpl)this.internalFunction).getA();
    }

    @Override
    public double getB() {
        return ((UniformDistributionImpl)this.internalFunction).getB();
    }
}

