/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BooleanOperations implements Enumerator
{
    AND(0, "AND", "AND"),
    OR(1, "OR", "OR"),
    XOR(2, "XOR", "XOR");

    public static final String copyright = "Copyright 2007-2009, SDQ, IPD, U Karlsruhe";
    public static final int AND_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int XOR_VALUE = 2;
    private static final BooleanOperations[] VALUES_ARRAY;
    public static final List<BooleanOperations> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BooleanOperations[]{AND, OR, XOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BooleanOperations get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanOperations result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanOperations getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanOperations result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanOperations get(int value) {
        switch (value) {
            case 0: {
                return AND;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return XOR;
            }
        }
        return null;
    }

    private BooleanOperations(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

