/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.blackboard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ResourceSetPartition {
    private final Logger logger = Logger.getLogger(ResourceSetPartition.class);
    protected ResourceSet rs = new ResourceSetImpl();

    public ResourceSet getResourceSet() {
        return this.rs;
    }

    public void initialiseResourceSetEPackages(EPackage[] ePackages) {
        EPackage[] ePackageArray = ePackages;
        int n = ePackages.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage ePackage = ePackageArray[n2];
            this.rs.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
            ++n2;
        }
    }

    public Resource loadModel(URI modelURI) {
        return this.rs.getResource(modelURI, true);
    }

    public List<EObject> getContents(URI modelURI) {
        Resource r = this.rs.getResource(modelURI, false);
        if (r == null) {
            throw new IllegalArgumentException("Model with URI " + modelURI + " must be loaded first");
        }
        return r.getContents();
    }

    public EObject getFirstContentElement(URI modelURI) {
        return this.getContents(modelURI).get(0);
    }

    @Deprecated
    public Resource loadModel(String modelURI) {
        Resource r = URI.createURI((String)modelURI).isPlatform() || modelURI.indexOf("://") >= 0 ? this.loadModel(URI.createURI((String)modelURI)) : this.loadModel(URI.createFileURI((String)modelURI));
        return r;
    }

    public void resolveAllProxies() {
        ArrayList currentResources = null;
        do {
            currentResources = new ArrayList(this.rs.getResources());
            for (Resource r : currentResources) {
                EcoreUtil.resolveAll((Resource)r);
            }
        } while (currentResources.size() != this.rs.getResources().size());
    }

    public void setContents(URI modelID, List<EObject> newContents) {
        Resource r;
        if (!this.hasModel(modelID)) {
            this.getResourceSet().createResource(modelID);
        }
        if (newContents != (r = this.getResourceSet().getResource(modelID, false)).getContents()) {
            r.getContents().clear();
            r.getContents().addAll(newContents);
        }
    }

    public void setContents(URI modelID, EObject newContents) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        list.add(newContents);
        this.setContents(modelID, list);
    }

    public boolean hasModel(URI modelURI) {
        return this.rs.getResource(modelURI, false) != null;
    }

    public void storeAllResources() throws IOException {
        this.storeAllResources(null);
    }

    public void storeAllResources(Map<String, Object> saveOptions) throws IOException {
        for (Resource r : this.rs.getResources()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Save resource " + r.getURI()));
            }
            if (!r.getURI().isFile() && !r.getURI().isPlatformResource()) continue;
            r.save(saveOptions);
        }
    }

    public <T extends EObject> List<T> getElement(EClass targetType) {
        ArrayList result = new ArrayList();
        for (Resource r : this.rs.getResources()) {
            if (!this.isTargetInResource(targetType, r)) continue;
            result.addAll(EcoreUtil.getObjectsByType((Collection)r.getContents(), (EClassifier)targetType));
        }
        return result;
    }

    private boolean isTargetInResource(EClass targetType, Resource r) {
        if (r != null) {
            for (EObject c : r.getContents()) {
                if (!targetType.isSuperTypeOf(c.eClass())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasElement(EClass targetType) {
        for (Resource r : this.rs.getResources()) {
            if (!this.isTargetInResource(targetType, r)) continue;
            return true;
        }
        return false;
    }
}

