/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow;

import de.uka.ipd.sdq.workflow.WorkflowExceptionHandler;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.ICompositeJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class Workflow
extends SequentialJob
implements ICompositeJob {
    private IProgressMonitor myMonitor;
    protected WorkflowExceptionHandler exceptionHandler = null;

    public Workflow(IJob job) {
        this(job, null, new WorkflowExceptionHandler(false));
    }

    public Workflow(IJob job, WorkflowExceptionHandler exceptionHandler) {
        this(job, null, exceptionHandler);
    }

    public Workflow(IJob job, IProgressMonitor monitor, WorkflowExceptionHandler workflowExceptionHandler) {
        this.addJob(job);
        this.exceptionHandler = workflowExceptionHandler;
        this.myMonitor = monitor != null ? monitor : new NullProgressMonitor();
        this.logger = Logger.getLogger(Workflow.class);
        this.setName("Workflow");
    }

    /*
     * Loose catch block
     */
    public void run() {
        block32: {
            if (this.logger.isEnabledFor((Priority)Level.INFO)) {
                this.logger.info((Object)"Creating workflow engine and starting workflow");
            }
            this.myMonitor.beginTask("Workflow", 1);
            this.myMonitor.subTask(this.getName());
            try {
                this.execute(this.myMonitor);
            }
            catch (JobFailedException e) {
                if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
                    this.logger.error((Object)"Workflow job failed, handling failure...");
                    this.logger.error((Object)"Failure reason was: ", (Throwable)e);
                }
                this.exceptionHandler.handleJobFailed(e);
                if (this.logger.isEnabledFor((Priority)Level.INFO)) {
                    this.logger.info((Object)"Cleaning up...");
                }
                try {
                    this.cleanup(this.myMonitor);
                }
                catch (CleanupFailedException e2) {
                    if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
                        this.logger.error((Object)"Critical failure during workflow cleanup");
                    }
                    this.exceptionHandler.handleCleanupFailed(e2);
                }
                break block32;
            }
            catch (UserCanceledException e) {
                if (this.logger.isEnabledFor((Priority)Level.INFO)) {
                    this.logger.info((Object)"User canceled workflow");
                }
                this.exceptionHandler.handleUserCanceled(e);
                break block32;
            }
            catch (Exception e) {
                if (this.logger.isEnabledFor((Priority)Level.FATAL)) {
                    this.logger.fatal((Object)"Workflow terminated unexpectedly", (Throwable)e);
                }
                this.exceptionHandler.handleFatalFailure(e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                if (this.logger.isEnabledFor((Priority)Level.INFO)) {
                    this.logger.info((Object)"Cleaning up...");
                }
                try {
                    this.cleanup(this.myMonitor);
                }
                catch (CleanupFailedException e3) {
                    if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
                        this.logger.error((Object)"Critical failure during workflow cleanup");
                    }
                    this.exceptionHandler.handleCleanupFailed(e3);
                }
                break block32;
            }
            {
                finally {
                    if (this.logger.isEnabledFor((Priority)Level.INFO)) {
                        this.logger.info((Object)"Cleaning up...");
                    }
                    try {
                        this.cleanup(this.myMonitor);
                    }
                    catch (CleanupFailedException e) {
                        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
                            this.logger.error((Object)"Critical failure during workflow cleanup");
                        }
                        this.exceptionHandler.handleCleanupFailed(e);
                    }
                }
            }
            if (this.logger.isEnabledFor((Priority)Level.INFO)) {
                this.logger.info((Object)"Cleaning up...");
            }
            try {
                this.cleanup(this.myMonitor);
            }
            catch (CleanupFailedException e) {
                if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
                    this.logger.error((Object)"Critical failure during workflow cleanup");
                }
                this.exceptionHandler.handleCleanupFailed(e);
            }
        }
        this.myMonitor.worked(1);
        this.myMonitor.done();
        if (this.logger.isEnabledFor((Priority)Level.INFO)) {
            this.logger.info((Object)"Workflow engine completed task");
        }
    }
}

