/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffAction;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.SeffFactory;

public class ExternalCallActionCreator
extends SeffAction {
    private Integer retryCount;
    private OperationSignature signature;
    private OperationRequiredRole requiredRole;
    private final List<VariableUsage> inputVariableUsages;
    private final List<VariableUsage> returnVariableUsages;
    private final List<FailureType> failures;

    protected ExternalCallActionCreator(SeffCreator seff) {
        this.seff = seff;
        this.inputVariableUsages = new ArrayList<VariableUsage>();
        this.returnVariableUsages = new ArrayList<VariableUsage>();
        this.failures = new ArrayList<FailureType>();
    }

    @Override
    public ExternalCallActionCreator withName(String name) {
        return (ExternalCallActionCreator)super.withName(name);
    }

    public ExternalCallActionCreator withRetryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public ExternalCallActionCreator withCalledService(OperationSignature signature) {
        IllegalArgumentException.throwIfNull(signature, "signature must not be null");
        this.signature = signature;
        return this;
    }

    public ExternalCallActionCreator withRequiredRole(OperationRequiredRole requiredRole) {
        IllegalArgumentException.throwIfNull(requiredRole, "requiredRole must not be null");
        this.requiredRole = requiredRole;
        return this;
    }

    public ExternalCallActionCreator withInputVariableUsage(VariableUsageCreator variableUsage) {
        IllegalArgumentException.throwIfNull(variableUsage, "variableUsage must not be null");
        this.inputVariableUsages.add(variableUsage.build());
        return this;
    }

    public ExternalCallActionCreator withReturnVariableUsage(VariableUsageCreator variableUsage) {
        IllegalArgumentException.throwIfNull(variableUsage, "variableUsage must not be null");
        this.returnVariableUsages.add(variableUsage.build());
        return this;
    }

    public ExternalCallActionCreator withFailureType(FailureType failure) {
        IllegalArgumentException.throwIfNull(failure, "failure must not be null");
        this.failures.add(failure);
        return this;
    }

    protected ExternalCallAction build() {
        ExternalCallAction action = SeffFactory.eINSTANCE.createExternalCallAction();
        if (this.name != null) {
            action.setEntityName(this.name);
        }
        if (this.retryCount != null) {
            action.setRetryCount(this.retryCount.intValue());
        }
        if (this.signature != null) {
            action.setCalledService_ExternalService(this.signature);
        }
        if (this.requiredRole != null) {
            action.setRole_ExternalService(this.requiredRole);
        }
        action.getInputVariableUsages__CallAction().addAll(this.inputVariableUsages);
        action.getReturnVariableUsage__CallReturnAction().addAll(this.returnVariableUsages);
        action.getFailureTypes_FailureHandlingEntity().addAll(this.failures);
        return action;
    }
}

