/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.resourceenvironment.structure;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.HddProcessingResourceSpecificationCreator;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.ProcessingResourceSpecificationCreator;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.ResourceEntity;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.ResourceEnvironmentCreator;
import org.palladiosimulator.pcm.resourceenvironment.HDDProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;

public class ResourceContainerCreator
extends ResourceEntity {
    private final List<ProcessingResourceSpecification> processingResourceSpecifications = new ArrayList<ProcessingResourceSpecification>();
    private final List<HDDProcessingResourceSpecification> hddProcessingResourceSpecifications = new ArrayList<HDDProcessingResourceSpecification>();
    private final List<ResourceContainer> nestedResourceContainers = new ArrayList<ResourceContainer>();

    public ResourceContainerCreator(ResourceEnvironmentCreator resourceCreator) {
        this.resourceCreator = resourceCreator;
    }

    public ResourceContainerCreator addProcessingResourceSpecification(ProcessingResourceSpecificationCreator processingResourceSpecification) {
        IllegalArgumentException.throwIfNull(processingResourceSpecification, "The given ProcessingResourceSpecification must not be null");
        this.processingResourceSpecifications.add(processingResourceSpecification.build());
        return this;
    }

    public ResourceContainerCreator addHddProcessingResourceSpecification(HddProcessingResourceSpecificationCreator hddProcessingResourceSpecification) {
        IllegalArgumentException.throwIfNull(hddProcessingResourceSpecification, "The given HddProcessingResourceSpecification must not be null");
        this.hddProcessingResourceSpecifications.add(hddProcessingResourceSpecification.build());
        return this;
    }

    public ResourceContainerCreator addNestedResourceContainer(ResourceContainerCreator resourceContainer) {
        IllegalArgumentException.throwIfNull(resourceContainer, "The given ResourceContainer must not be null");
        this.nestedResourceContainers.add(resourceContainer.build());
        return this;
    }

    @Override
    public ResourceContainerCreator withName(String name) {
        return (ResourceContainerCreator)super.withName(name);
    }

    protected ResourceContainer build() {
        ResourceContainer container = ResourceenvironmentFactory.eINSTANCE.createResourceContainer();
        if (this.name != null) {
            container.setEntityName(this.name);
        }
        container.getActiveResourceSpecifications_ResourceContainer().addAll(this.processingResourceSpecifications);
        container.getActiveResourceSpecifications_ResourceContainer().addAll(this.hddProcessingResourceSpecifications);
        container.getHddResourceSpecifications().addAll(this.hddProcessingResourceSpecifications);
        container.getNestedResourceContainers__ResourceContainer().addAll(this.nestedResourceContainers);
        return container;
    }
}

