/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.factory;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.palladiosimulator.generator.fluent.exceptions.FluentApiException;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.repository.api.Repo;
import org.palladiosimulator.generator.fluent.repository.api.seff.InternalSeff;
import org.palladiosimulator.generator.fluent.repository.api.seff.RecoverySeff;
import org.palladiosimulator.generator.fluent.repository.api.seff.Seff;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.BasicComponentCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.CompleteComponentTypeCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.CompositeComponentCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.ProvidesComponentTypeCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.SubSystemCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.EventGroupCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.EventTypeCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.InfrastructureInterfaceCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.InfrastructureSignatureCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.OperationInterfaceCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.OperationSignatureCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Failure;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Primitive;
import org.palladiosimulator.generator.fluent.repository.structure.types.CompositeDataTypeCreator;
import org.palladiosimulator.generator.fluent.repository.structure.types.ExceptionTypeCreator;
import org.palladiosimulator.generator.fluent.repository.structure.types.ResourceTimeoutFailureTypeCreator;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.CommunicationLinkResource;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.generator.fluent.shared.util.ModelLoader;
import org.palladiosimulator.generator.fluent.shared.validate.ModelValidator;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.EventChannel;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.reliability.HardwareInducedFailureType;
import org.palladiosimulator.pcm.reliability.NetworkInducedFailureType;
import org.palladiosimulator.pcm.reliability.ReliabilityFactory;
import org.palladiosimulator.pcm.reliability.ResourceTimeoutFailureType;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompleteComponentType;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.ExceptionType;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidesComponentType;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryActionBehaviour;
import org.palladiosimulator.pcm.subsystem.SubSystem;

public class FluentRepositoryFactory {
    private RepositoryCreator repo;
    private final Repository primitives;
    private final ResourceRepository resourceTypes;
    private final Repository failures;

    public FluentRepositoryFactory() {
        EcorePlugin.ExtensionProcessor.process(null);
        this.primitives = ModelLoader.loadRepository("pathmap://PCM_MODELS/PrimitiveTypes.repository");
        this.resourceTypes = ModelLoader.loadResourceTypeRepository("pathmap://PCM_MODELS/Palladio.resourcetype");
        this.failures = ModelLoader.loadRepository("pathmap://PCM_MODELS/FailureTypes.repository");
    }

    public Repo newRepository() {
        Logger logger = Logger.getLogger("global");
        logger.setLevel(Level.ALL);
        ModelValidator validator = new ModelValidator(logger);
        this.repo = new RepositoryCreator(this.primitives, this.resourceTypes, this.failures, logger, validator);
        return this.repo;
    }

    public BasicComponentCreator newBasicComponent() {
        return new BasicComponentCreator(this.repo);
    }

    public CompositeComponentCreator newCompositeComponent() {
        return new CompositeComponentCreator(this.repo);
    }

    public SubSystemCreator newSubSystem() {
        return new SubSystemCreator(this.repo);
    }

    public CompleteComponentTypeCreator newCompleteComponentType() {
        return new CompleteComponentTypeCreator(this.repo);
    }

    public ProvidesComponentTypeCreator newProvidesComponentType() {
        return new ProvidesComponentTypeCreator(this.repo);
    }

    public OperationInterfaceCreator newOperationInterface() {
        return new OperationInterfaceCreator(this.repo);
    }

    public InfrastructureInterfaceCreator newInfrastructureInterface() {
        return new InfrastructureInterfaceCreator(this.repo);
    }

    public EventGroupCreator newEventGroup() {
        return new EventGroupCreator(this.repo);
    }

    public CollectionDataType newCollectionDataType(String name, Primitive primitive) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        PrimitiveDataType p = this.repo.getPrimitiveDataType(primitive);
        CollectionDataType coll = RepositoryFactory.eINSTANCE.createCollectionDataType();
        coll.setEntityName(name);
        coll.setInnerType_CollectionDataType((DataType)p);
        return coll;
    }

    public static CollectionDataType newCollectionDataType(String name, DataType dataType) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        CollectionDataType coll = RepositoryFactory.eINSTANCE.createCollectionDataType();
        coll.setEntityName(name);
        coll.setInnerType_CollectionDataType(dataType);
        return coll;
    }

    public CompositeDataTypeCreator newCompositeDataType() {
        return new CompositeDataTypeCreator(this.repo);
    }

    public HardwareInducedFailureType newHardwareInducedFailureType(String name, ProcessingResource processingResource) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        HardwareInducedFailureType h = ReliabilityFactory.eINSTANCE.createHardwareInducedFailureType();
        h.setEntityName(name);
        h.setProcessingResourceType__HardwareInducedFailureType(this.repo.getProcessingResourceType(processingResource));
        return h;
    }

    public NetworkInducedFailureType newNetworkInducedFailureType(String name, CommunicationLinkResource communicationLinkResource) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        NetworkInducedFailureType n = ReliabilityFactory.eINSTANCE.createNetworkInducedFailureType();
        n.setEntityName(name);
        n.setCommunicationLinkResourceType__NetworkInducedFailureType(this.repo.getCommunicationLinkResource(communicationLinkResource));
        return n;
    }

    public ResourceTimeoutFailureTypeCreator newResourceTimeoutFailureType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        return new ResourceTimeoutFailureTypeCreator(name, this.repo);
    }

    public static SoftwareInducedFailureType newSoftwareInducedFailureType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        SoftwareInducedFailureType s = ReliabilityFactory.eINSTANCE.createSoftwareInducedFailureType();
        s.setEntityName(name);
        return s;
    }

    public ExceptionTypeCreator newExceptionType() {
        return new ExceptionTypeCreator(this.repo);
    }

    public Seff newSeff() {
        return new SeffCreator(this.repo);
    }

    public InternalSeff newInternalBehaviour() {
        return new SeffCreator(this.repo);
    }

    public RecoverySeff newRecoveryBehaviour() {
        return new SeffCreator(this.repo);
    }

    public OperationSignatureCreator newOperationSignature() {
        return new OperationSignatureCreator(this.repo);
    }

    public InfrastructureSignatureCreator newInfrastructureSignature() {
        return new InfrastructureSignatureCreator(this.repo);
    }

    public EventTypeCreator newEventType() {
        return new EventTypeCreator(this.repo);
    }

    public VariableUsageCreator newVariableUsage() {
        return new VariableUsageCreator();
    }

    public CompositeDataType fetchOfCompositeDataType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        CompositeDataType dataType = this.repo.getCompositeDataType(name);
        if (dataType == null) {
            throw new FluentApiException("Composite data type '" + name + "' could not be found");
        }
        return dataType;
    }

    public DataType fetchOfDataType(Primitive primitive) {
        PrimitiveDataType p = this.repo.getPrimitiveDataType(primitive);
        if (p == null) {
            throw new FluentApiException("Primitive data Type '" + (Object)((Object)primitive) + "' could not be found");
        }
        return p;
    }

    public DataType fetchOfDataType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        DataType dataType = this.repo.getDataType(name);
        if (dataType == null) {
            dataType = this.repo.getPrimitiveDataType(name);
        }
        if (dataType == null) {
            throw new FluentApiException("Datatype '" + name + "' could not be found");
        }
        return dataType;
    }

    public boolean containsDataType(String name) {
        try {
            return this.repo.getDataType(name) != null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    public ResourceTimeoutFailureType fetchOfResourceTimeoutFailureType(String name) {
        ResourceTimeoutFailureType failureType = this.repo.getResourceTimeoutFailureType(name);
        if (failureType == null) {
            throw new FluentApiException("Failure Type '" + name + "' could not be found");
        }
        return failureType;
    }

    public FailureType fetchOfFailureType(Failure failure) {
        FailureType f = this.repo.getFailureType(failure);
        if (f == null) {
            throw new FluentApiException("Failure Type '" + (Object)((Object)failure) + "' could not be found");
        }
        return f;
    }

    public FailureType fetchOfFailureType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        FailureType f = this.repo.getFailureType(name);
        if (f == null) {
            throw new FluentApiException("Failure Type '" + name + "' could not be found");
        }
        return f;
    }

    public ExceptionType fetchOfExceptionType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        ExceptionType e = this.repo.getExceptionType(name);
        if (e == null) {
            throw new FluentApiException("Failure Type '" + name + "' could not be found");
        }
        return e;
    }

    public RepositoryComponent fetchOfComponent(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        RepositoryComponent component = this.repo.getComponent(name);
        if (component == null) {
            throw new FluentApiException("Component '" + name + "' could not be found");
        }
        return component;
    }

    public BasicComponent fetchOfBasicComponent(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        BasicComponent component = this.repo.getBasicComponent(name);
        if (component == null) {
            throw new FluentApiException("BasicComponent '" + name + "' could not be found");
        }
        return component;
    }

    public CompositeComponent fetchOfCompositeComponent(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        CompositeComponent component = this.repo.getCompositeComponent(name);
        if (component == null) {
            throw new FluentApiException("CompositeComponent '" + name + "' could not be found");
        }
        return component;
    }

    public SubSystem fetchOfSubSystem(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        SubSystem component = this.repo.getSubsystem(name);
        if (component == null) {
            throw new FluentApiException("Subsystem '" + name + "' could not be found");
        }
        return component;
    }

    public CompleteComponentType fetchOfCompleteComponentType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        CompleteComponentType component = this.repo.getCompleteComponentType(name);
        if (component == null) {
            throw new FluentApiException("CompleteComponentType '" + name + "' could not be found");
        }
        return component;
    }

    public ProvidesComponentType fetchOfProvidesComponentType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        ProvidesComponentType component = this.repo.getProvidesComponentType(name);
        if (component == null) {
            throw new FluentApiException("ProvidesComponentType '" + name + "' could not be found");
        }
        return component;
    }

    public Interface fetchOfInterface(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        Interface interfce = this.repo.getInterface(name);
        if (interfce == null) {
            throw new FluentApiException("Interface '" + name + "' could not be found");
        }
        return interfce;
    }

    public OperationInterface fetchOfOperationInterface(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        OperationInterface interfce = this.repo.getOperationInterface(name);
        if (interfce == null) {
            throw new FluentApiException("OperationInterface '" + name + "' could not be found");
        }
        return interfce;
    }

    public InfrastructureInterface fetchOfInfrastructureInterface(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        InfrastructureInterface interfce = this.repo.getInfrastructureInterface(name);
        if (interfce == null) {
            throw new FluentApiException("InfrastructureInterface '" + name + "' could not be found");
        }
        return interfce;
    }

    public EventGroup fetchOfEventGroup(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        EventGroup interfce = this.repo.getEventGroup(name);
        if (interfce == null) {
            throw new FluentApiException("EventGroup '" + name + "' could not be found");
        }
        return interfce;
    }

    public ProvidedRole fetchOfProvidedRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        ProvidedRole provRole = this.repo.getProvidedRole(name);
        if (provRole == null) {
            throw new FluentApiException("ProvidedRole '" + name + "' could not be found");
        }
        return provRole;
    }

    public OperationProvidedRole fetchOfOperationProvidedRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        OperationProvidedRole provRole = this.repo.getOperationProvidedRole(name);
        if (provRole == null) {
            throw new FluentApiException("ProvidedRole '" + name + "' could not be found");
        }
        return provRole;
    }

    public InfrastructureProvidedRole fetchOfInfrastructureProvidedRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        InfrastructureProvidedRole provRole = this.repo.getInfrastructureProvidedRole(name);
        if (provRole == null) {
            throw new FluentApiException("ProvidedRole '" + name + "' could not be found");
        }
        return provRole;
    }

    public SinkRole fetchOfSinkRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        SinkRole provRole = this.repo.getSinkRole(name);
        if (provRole == null) {
            throw new FluentApiException("SinkRole '" + name + "' could not be found");
        }
        return provRole;
    }

    public RequiredRole fetchOfRequiredRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        RequiredRole reqRole = this.repo.getRequiredRole(name);
        if (reqRole == null) {
            throw new FluentApiException("RequiredRole '" + name + "' could not be found");
        }
        return reqRole;
    }

    public OperationRequiredRole fetchOfOperationRequiredRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        OperationRequiredRole reqRole = this.repo.getOperationRequiredRole(name);
        if (reqRole == null) {
            throw new FluentApiException("RequiredRole '" + name + "' could not be found");
        }
        return reqRole;
    }

    public InfrastructureRequiredRole fetchOfInfrastructureRequiredRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        InfrastructureRequiredRole reqRole = this.repo.getInfrastructureRequiredRole(name);
        if (reqRole == null) {
            throw new FluentApiException("RequiredRole '" + name + "' could not be found");
        }
        return reqRole;
    }

    public SourceRole fetchOfSourceRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        SourceRole reqRole = this.repo.getSourceRole(name);
        if (reqRole == null) {
            throw new FluentApiException("SourceRole '" + name + "' could not be found");
        }
        return reqRole;
    }

    public ResourceRequiredRole fetchOfResourceRequiredRole(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        ResourceRequiredRole reqRole = this.repo.getResourceRequiredRole(name);
        if (reqRole == null) {
            throw new FluentApiException("ResourceRequiredRole '" + name + "' could not be found");
        }
        return reqRole;
    }

    public Signature fetchOfSignature(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        Signature signature = this.repo.getSignature(name);
        if (signature == null) {
            throw new FluentApiException("Signature '" + name + "' could not be found");
        }
        return signature;
    }

    public OperationSignature fetchOfOperationSignature(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        OperationSignature signature = this.repo.getOperationSignature(name);
        if (signature == null) {
            throw new FluentApiException("Operation signature '" + name + "' could not be found");
        }
        return signature;
    }

    public InfrastructureSignature fetchOfInfrastructureSignature(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        InfrastructureSignature signature = this.repo.getInfrastructureSignature(name);
        if (signature == null) {
            throw new FluentApiException("Operation signature '" + name + "' could not be found");
        }
        return signature;
    }

    public EventType fetchOfEventType(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        EventType eventType = this.repo.getEventType(name);
        if (eventType == null) {
            throw new FluentApiException("EventType '" + name + "' could not be found");
        }
        return eventType;
    }

    public AssemblyContext fetchOfAssemblyContext(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        AssemblyContext assContext = this.repo.getAssemblyContext(name);
        if (assContext == null) {
            throw new FluentApiException("Assembly context '" + name + "' could not be found");
        }
        return assContext;
    }

    public EventChannel fetchOfEventChannel(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        EventChannel eventChannel = this.repo.getEventChannel(name);
        if (eventChannel == null) {
            throw new FluentApiException("Event Channel '" + name + "' could not be found");
        }
        return eventChannel;
    }

    public Parameter fetchOfParameter(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        Parameter p = this.repo.getParameter(name);
        if (p == null) {
            throw new FluentApiException("Parameter '" + name + "' could not be found");
        }
        return p;
    }

    public Parameter fetchOfParameter(String name, Signature context) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        Parameter p = this.repo.getParameter(name, context);
        if (p == null) {
            throw new FluentApiException("Parameter '" + name + "' could not be found");
        }
        return p;
    }

    public PassiveResource fetchOfPassiveResource(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        PassiveResource r = this.repo.getPassiveResource(name);
        if (r == null) {
            throw new FluentApiException("Passive Resource '" + name + "' could not be found");
        }
        return r;
    }

    public RecoveryActionBehaviour fetchOfRecoveryActionBehaviour(String name) {
        IllegalArgumentException.throwIfNull(name, "name must not be null");
        RecoveryActionBehaviour r = this.repo.getRecoveryActionBehaviour(name);
        if (r == null) {
            throw new FluentApiException("Recovery action behaviour '" + name + "' could not be found");
        }
        return r;
    }
}

