/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.api.seff.ActionSeff;
import org.palladiosimulator.generator.fluent.repository.api.seff.InternalSeff;
import org.palladiosimulator.generator.fluent.repository.api.seff.RecoverySeff;
import org.palladiosimulator.generator.fluent.repository.api.seff.Seff;
import org.palladiosimulator.generator.fluent.repository.api.seff.StartSeff;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryCreator;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryEntity;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.AcquireActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.BranchActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.CollectionIteratorActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.EmitEventActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.ExternalCallActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.ForkActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.InternalActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.InternalCallActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.LoopActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.RecoveryActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.ReleaseActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SetVariableActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.StartActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.StopActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Failure;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingInternalBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryActionBehaviour;
import org.palladiosimulator.pcm.seff.seff_reliability.SeffReliabilityFactory;

public class SeffCreator
extends RepositoryEntity
implements Seff,
ActionSeff,
StartSeff,
InternalSeff,
RecoverySeff {
    private AbstractAction current;
    private Signature signature;
    private String seffTypeID;
    private final List<AbstractAction> steps;
    private final List<InternalSeff> internalBehaviours;
    private final List<FailureType> failures;
    private final List<RecoveryActionBehaviour> alternatives;

    public SeffCreator(RepositoryCreator repo) {
        this.repository = repo;
        this.steps = new ArrayList<AbstractAction>();
        this.internalBehaviours = new ArrayList<InternalSeff>();
        this.failures = new ArrayList<FailureType>();
        this.alternatives = new ArrayList<RecoveryActionBehaviour>();
    }

    @Override
    public StartActionCreator withStartAction() {
        return new StartActionCreator(this);
    }

    @Override
    public StopActionCreator stopAction() {
        return new StopActionCreator(this);
    }

    @Override
    public InternalActionCreator internalAction() {
        return new InternalActionCreator(this);
    }

    @Override
    public InternalCallActionCreator internalCallAction() {
        return new InternalCallActionCreator(this);
    }

    @Override
    public ExternalCallActionCreator externalCallAction() {
        return new ExternalCallActionCreator(this);
    }

    @Override
    public EmitEventActionCreator emitEventAction() {
        return new EmitEventActionCreator(this);
    }

    @Override
    public AcquireActionCreator acquireAction() {
        return new AcquireActionCreator(this);
    }

    @Override
    public ReleaseActionCreator releaseAction() {
        return new ReleaseActionCreator(this);
    }

    @Override
    public SetVariableActionCreator setVariableAction() {
        return new SetVariableActionCreator(this);
    }

    @Override
    public LoopActionCreator loopAction() {
        return new LoopActionCreator(this);
    }

    @Override
    public CollectionIteratorActionCreator collectionIteratorAction() {
        return new CollectionIteratorActionCreator(this);
    }

    @Override
    public BranchActionCreator branchAction() {
        return new BranchActionCreator(this);
    }

    @Override
    public ForkActionCreator forkAction() {
        return new ForkActionCreator(this);
    }

    @Override
    public RecoveryActionCreator recoveryAction() {
        return new RecoveryActionCreator(this, this.repository);
    }

    @Override
    public SeffCreator withName(String name) {
        return (SeffCreator)super.withName(name);
    }

    @Override
    public SeffCreator onSignature(Signature signature) {
        IllegalArgumentException.throwIfNull(signature, "signature must not be null");
        this.signature = signature;
        return this;
    }

    @Override
    public SeffCreator withSeffTypeID(String seffTypeID) {
        IllegalArgumentException.throwIfNull(seffTypeID, "seffTypeID must not be null");
        this.seffTypeID = seffTypeID;
        return this;
    }

    @Override
    public SeffCreator withInternalBehaviour(InternalSeff internalBehaviour) {
        IllegalArgumentException.throwIfNull(internalBehaviour, "internalBehaviour must not be null");
        this.internalBehaviours.add(internalBehaviour);
        return this;
    }

    @Override
    public SeffCreator withSeffBehaviour() {
        return this;
    }

    @Override
    public SeffCreator withFailureType(Failure failure) {
        IllegalArgumentException.throwIfNull(failure, "failure must not be null");
        FailureType f = this.repository.getFailureType(failure);
        return this.withFailureType(f);
    }

    @Override
    public SeffCreator withFailureType(FailureType failureType) {
        IllegalArgumentException.throwIfNull(failureType, "failureType must not be null");
        this.failures.add(failureType);
        return this;
    }

    @Override
    public SeffCreator withAlternativeRecoveryBehaviour(RecoveryActionBehaviour recoveryBehaviour) {
        IllegalArgumentException.throwIfNull(recoveryBehaviour, "recoveryBehaviour must not be null");
        this.alternatives.add(recoveryBehaviour);
        return this;
    }

    @Override
    public ServiceEffectSpecification build() {
        return this.buildRDSeff();
    }

    @Override
    public ResourceDemandingSEFF buildRDSeff() {
        ResourceDemandingSEFF seff = SeffFactory.eINSTANCE.createResourceDemandingSEFF();
        if (this.signature != null) {
            seff.setDescribedService__SEFF(this.signature);
        }
        if (this.seffTypeID != null) {
            seff.setSeffTypeID(this.seffTypeID);
        }
        seff.getSteps_Behaviour().addAll(this.steps);
        seff.getResourceDemandingInternalBehaviours().addAll((Collection)this.internalBehaviours.stream().map(InternalSeff::buildInternalBehaviour).collect(Collectors.toList()));
        return seff;
    }

    @Override
    public ResourceDemandingBehaviour buildBehaviour() {
        ResourceDemandingBehaviour behaviour = SeffFactory.eINSTANCE.createResourceDemandingBehaviour();
        behaviour.getSteps_Behaviour().addAll(this.steps);
        return behaviour;
    }

    @Override
    public ResourceDemandingInternalBehaviour buildInternalBehaviour() {
        ResourceDemandingInternalBehaviour internal = SeffFactory.eINSTANCE.createResourceDemandingInternalBehaviour();
        internal.getSteps_Behaviour().addAll(this.steps);
        return internal;
    }

    @Override
    public ForkedBehaviour buildForkedBehaviour() {
        ForkedBehaviour fork = SeffFactory.eINSTANCE.createForkedBehaviour();
        fork.getSteps_Behaviour().addAll(this.steps);
        return fork;
    }

    @Override
    public RecoveryActionBehaviour buildRecoveryBehaviour() {
        RecoveryActionBehaviour recovActionBehaviour = SeffReliabilityFactory.eINSTANCE.createRecoveryActionBehaviour();
        if (this.name != null) {
            recovActionBehaviour.setEntityName(this.name);
        }
        recovActionBehaviour.getSteps_Behaviour().addAll(this.steps);
        recovActionBehaviour.getFailureHandlingAlternatives__RecoveryActionBehaviour().addAll(this.alternatives);
        recovActionBehaviour.getFailureTypes_FailureHandlingEntity().addAll(this.failures);
        return recovActionBehaviour;
    }

    protected void setNext(AbstractAction action) {
        if (this.current != null) {
            this.current.setSuccessor_AbstractAction(action);
            action.setPredecessor_AbstractAction(this.current);
        }
        this.current = action;
        this.steps.add(action);
    }
}

