/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.resourceenvironment.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.resourceenvironment.api.IResourceEnvironment;
import org.palladiosimulator.generator.fluent.resourceenvironment.api.IResourceEnvironmentAddition;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.LinkingResourceCreator;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.ResourceContainerCreator;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.ResourceEntity;
import org.palladiosimulator.generator.fluent.shared.structure.CommunicationLinkResource;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.generator.fluent.shared.structure.SchedulingPolicies;
import org.palladiosimulator.generator.fluent.shared.validate.IModelValidator;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.resourcetype.SchedulingPolicy;

public class ResourceEnvironmentCreator
extends ResourceEntity
implements IResourceEnvironment {
    private final IModelValidator validator;
    private final ResourceRepository resources;
    private final List<ResourceContainer> resourceContainers = new ArrayList<ResourceContainer>();
    private final List<LinkingResource> linkingResources = new ArrayList<LinkingResource>();

    public ResourceEnvironmentCreator(ResourceRepository resources, IModelValidator validator) {
        this.resources = resources;
        this.validator = validator;
    }

    @Override
    public ResourceEnvironmentCreator withName(String name) {
        return (ResourceEnvironmentCreator)super.withName(name);
    }

    @Override
    public ResourceEnvironment createResourceEnvironmentNow() {
        ResourceEnvironment environment = this.build();
        this.validator.validate((EObject)environment, this.name);
        return environment;
    }

    protected ResourceEnvironment build() {
        ResourceEnvironment environment = ResourceenvironmentFactory.eINSTANCE.createResourceEnvironment();
        if (this.name != null) {
            environment.setEntityName(this.name);
        }
        environment.getResourceContainer_ResourceEnvironment().addAll(this.resourceContainers);
        environment.getLinkingResources__ResourceEnvironment().addAll(this.linkingResources);
        return environment;
    }

    @Override
    public IResourceEnvironmentAddition addToResourceEnvironment(ResourceContainerCreator resourceContainer) {
        IllegalArgumentException.throwIfNull(resourceContainer, "The given ResourceContainer must not be null");
        this.resourceContainers.add(resourceContainer.build());
        return this;
    }

    @Override
    public IResourceEnvironmentAddition addToResourceEnvironment(LinkingResourceCreator linkingResource) {
        IllegalArgumentException.throwIfNull(linkingResource, "The given LinkingResource must not be null");
        this.linkingResources.add(linkingResource.build());
        return this;
    }

    public SchedulingPolicy getSchedulingPolicy(SchedulingPolicies policy) {
        IllegalArgumentException.throwIfNull(policy, "The given SchedulingPolicy must not be null");
        return this.resources.getSchedulingPolicies__ResourceRepository().stream().filter(x -> x.getEntityName().equals(policy.getPolicyName())).findFirst().get();
    }

    public ProcessingResourceType getProcessingResource(ProcessingResource resource) {
        IllegalArgumentException.throwIfNull(resource, "The given ProcessignResource must not be null");
        return (ProcessingResourceType)this.resources.getAvailableResourceTypes_ResourceRepository().stream().filter(x -> x.getEntityName().equals(resource.getResourceName())).findFirst().get();
    }

    public CommunicationLinkResourceType getCommunicationLinkResource(CommunicationLinkResource resource) {
        IllegalArgumentException.throwIfNull(resource, "The given CommunicationLinkResource must not be null");
        return (CommunicationLinkResourceType)this.resources.getAvailableResourceTypes_ResourceRepository().stream().filter(x -> x.getEntityName().equals(resource.getResourceName())).findFirst().get();
    }

    public ResourceContainer getResourceContainerByName(String name) throws IllegalArgumentException {
        return this.resourceContainers.stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No ResourceContainer with name " + name + " found"));
    }
}

