/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.usagemodel.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.validate.ModelValidator;
import org.palladiosimulator.generator.fluent.usagemodel.api.IUsageModel;
import org.palladiosimulator.generator.fluent.usagemodel.factory.OperationProvidedSignatureRole;
import org.palladiosimulator.generator.fluent.usagemodel.structure.UsageModelCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.ScenarioBehaviourCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.UsageScenarioCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.UserDataCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.BranchActionCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.BranchTransitionCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.DelayActionCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.EntryLevelSystemCallCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.LoopActionCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.StartActionCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.StopActionCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.workload.ClosedWorkloadCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.workload.OpenWorkloadCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.workload.WorkloadCreator;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.system.System;

public class FluentUsageModelFactory {
    private UsageModelCreator usgModelCreator;
    private final List<System> systems;
    private final Logger logger;

    public FluentUsageModelFactory() {
        EcorePlugin.ExtensionProcessor.process(null);
        this.systems = new ArrayList<System>();
        this.logger = Logger.getLogger("global");
        this.logger.setLevel(Level.ALL);
    }

    public FluentUsageModelFactory addSystem(System system) {
        this.systems.add(system);
        return this;
    }

    public IUsageModel newUsageModel() {
        ModelValidator validator = new ModelValidator(this.logger);
        this.usgModelCreator = new UsageModelCreator(validator);
        return this.usgModelCreator;
    }

    public UsageScenarioCreator newUsageScenario(ScenarioBehaviourCreator scenarioBehavior, WorkloadCreator workload) {
        return new UsageScenarioCreator(this.usgModelCreator, scenarioBehavior, workload);
    }

    public UserDataCreator newUserData(AssemblyContext context) {
        return new UserDataCreator(this.usgModelCreator, context);
    }

    public ScenarioBehaviourCreator newScenarioBehavior() {
        return new ScenarioBehaviourCreator(this.usgModelCreator);
    }

    public BranchActionCreator newBranchAction() {
        return new BranchActionCreator();
    }

    public BranchTransitionCreator newBranchTransition(ScenarioBehaviourCreator branchedBehaviour) {
        return new BranchTransitionCreator(branchedBehaviour);
    }

    public DelayActionCreator newDelayAction(String timeSpecification) {
        return new DelayActionCreator(timeSpecification);
    }

    private EntryLevelSystemCallCreator newEntryLevelSystemCall(OperationProvidedRole operationProvidedRole, OperationSignature operationSignature) {
        if (!operationProvidedRole.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface().contains((Object)operationSignature)) {
            throw new IllegalArgumentException("No OperationSignature with name " + operationSignature.getEntityName() + " for OperationProvidedRole " + operationProvidedRole.getEntityName() + " exits.");
        }
        return new EntryLevelSystemCallCreator(operationSignature, operationProvidedRole);
    }

    public EntryLevelSystemCallCreator newEntryLevelSystemCall(OperationProvidedSignatureRole operationProvided) {
        return this.newEntryLevelSystemCall(operationProvided.getRole(), operationProvided.getSignature());
    }

    public LoopActionCreator newLoopAction(String iteration, ScenarioBehaviourCreator bodyBehaviour) {
        return new LoopActionCreator(iteration, bodyBehaviour);
    }

    public StartActionCreator newStartAction() {
        return new StartActionCreator();
    }

    public StopActionCreator newStopAction() {
        return new StopActionCreator();
    }

    public ClosedWorkloadCreator newClosedWorkload(String thinkTime) {
        return new ClosedWorkloadCreator(this.usgModelCreator, thinkTime);
    }

    public OpenWorkloadCreator newOpenWorkload(String interArrivalTime) {
        return new OpenWorkloadCreator(this.usgModelCreator, interArrivalTime);
    }

    private System getSystemByName(String name) {
        List collect = this.systems.stream().filter(r -> r.getEntityName() != null && r.getEntityName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() > 1) {
            this.logger.warning("More than one system with name '" + name + "' found.");
        }
        return (System)collect.get(0);
    }

    public VariableUsageCreator newVariableUsage(String namespaceReference, String ... innerReferences) {
        return new VariableUsageCreator(namespaceReference, innerReferences);
    }

    public VariableUsageCreator newVariableUsage(String variableReference) {
        return new VariableUsageCreator(variableReference);
    }

    public AssemblyContext fetchOffAssemblyContextByName(String systemName, String assemblyName) {
        System system = this.getSystemByName(systemName);
        return system.getAssemblyContexts__ComposedStructure().stream().filter(x -> x.getEntityName().equals(assemblyName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No AssemblyContext with name " + assemblyName + " found."));
    }

    private OperationProvidedRole fetchOffOperationProvidedRoleByName(System system, String name) {
        OperationProvidedRole role = null;
        ProvidedRole r = system.getProvidedRoles_InterfaceProvidingEntity().stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No ProvidedRole with name " + name + " found."));
        if (r instanceof OperationProvidedRole) {
            role = (OperationProvidedRole)r;
        }
        IllegalArgumentException.throwIfNull(role, "No OperationProvidedRole with name " + name + " found.");
        return role;
    }

    public OperationProvidedSignatureRole fetchOffOperationRoleAndSignature(String systemName, String operationProvidedRole, String operationSignature) {
        System system = this.getSystemByName(systemName);
        OperationProvidedRole role = this.fetchOffOperationProvidedRoleByName(system, operationProvidedRole);
        OperationSignature sig = role.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface().stream().filter(x -> x.getEntityName().equals(operationSignature)).findFirst().orElseThrow(() -> new IllegalArgumentException("No OperationSignature with name " + operationSignature + " for OperationProvidedRole " + operationProvidedRole + " found."));
        return new OperationProvidedSignatureRole(role, sig);
    }
}

