/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.usagemodel.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.shared.validate.IModelValidator;
import org.palladiosimulator.generator.fluent.usagemodel.api.IUsageModel;
import org.palladiosimulator.generator.fluent.usagemodel.api.IUsageModelAddition;
import org.palladiosimulator.generator.fluent.usagemodel.structure.UsageModelEntity;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.UsageScenarioCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.UserDataCreator;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;
import org.palladiosimulator.pcm.usagemodel.UserData;

public class UsageModelCreator
extends UsageModelEntity
implements IUsageModel,
IUsageModelAddition {
    private final IModelValidator validator;
    private final List<UsageScenario> usageScenarios;
    private final List<UserData> userDatas;

    public UsageModelCreator(IModelValidator validator) {
        this.validator = validator;
        this.usageScenarios = new ArrayList<UsageScenario>();
        this.userDatas = new ArrayList<UserData>();
    }

    @Override
    public UsageModel createUsageModelNow() {
        UsageModel usgModel = this.build();
        this.validator.validate((EObject)usgModel, "UsageModel");
        return usgModel;
    }

    protected UsageModel build() {
        UsageModel usgModel = UsagemodelFactory.eINSTANCE.createUsageModel();
        usgModel.getUserData_UsageModel().addAll(this.userDatas);
        usgModel.getUsageScenario_UsageModel().addAll(this.usageScenarios);
        return usgModel;
    }

    @Override
    public IUsageModelAddition addToUsageModel(UserDataCreator userData) {
        IllegalArgumentException.throwIfNull(userData, "The given UserData must not be null");
        this.userDatas.add(userData.build());
        return this;
    }

    @Override
    public IUsageModelAddition addToUsageModel(UsageScenarioCreator usageScenario) {
        IllegalArgumentException.throwIfNull(usageScenario, "The given UsageScenario must not be null");
        this.usageScenarios.add(usageScenario.build());
        return this;
    }
}

