/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.examples;

import org.palladiosimulator.generator.fluent.repository.factory.FluentRepositoryFactory;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Primitive;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.generator.fluent.shared.structure.ResourceInterface;
import org.palladiosimulator.generator.fluent.shared.util.ModelSaver;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.core.entity.InterfaceRequiringEntity;
import org.palladiosimulator.pcm.parameter.VariableCharacterisationType;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.ParameterModifier;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;

class Example {
    Example() {
    }

    public static void main(String[] args) {
        Example.fetchExample();
    }

    public static void fetchExample() {
        FluentRepositoryFactory create = new FluentRepositoryFactory();
        Repository repository = create.newRepository().withName("example").addToRepository(create.newCollectionDataType("String List", Primitive.STRING)).addToRepository(create.newCompositeDataType().withName("Person").withInnerDeclaration("names", create.fetchOfDataType("String List")).withInnerDeclaration("age", Primitive.INTEGER)).createRepositoryNow();
        create = new FluentRepositoryFactory();
        create.newRepository().withImportedResource(repository);
        CompositeDataType person = create.fetchOfCompositeDataType("example.Person");
        System.out.println(repository.getDataTypes__Repository().get(1) == person);
    }

    public static void invalidExample() {
        FluentRepositoryFactory create = new FluentRepositoryFactory();
        Repository repository = create.newRepository().withName("invalid").addToRepository(create.newCompleteComponentType()).createRepositoryNow();
        ModelSaver.saveRepository(repository, "./", "invalid");
    }

    public static void miniExample() {
        FluentRepositoryFactory create = new FluentRepositoryFactory();
        Repository repository = create.newRepository().addToRepository(create.newCollectionDataType("String List", Primitive.STRING)).addToRepository(create.newCompositeDataType().withName("Person").withInnerDeclaration("names", create.fetchOfDataType("String List")).withInnerDeclaration("age", Primitive.INTEGER)).addToRepository((FailureType)create.newHardwareInducedFailureType("CPU Hardware Error", ProcessingResource.CPU)).addToRepository(create.newOperationInterface().withName("parent interface")).addToRepository(create.newOperationInterface().withName("interface").withOperationSignature(create.newOperationSignature().withName("signature").withParameter("parameter", create.fetchOfDataType("Person"), ParameterModifier.IN)).withRequiredCharacterisation(create.fetchOfParameter("parameter"), VariableCharacterisationType.STRUCTURE).conforms(create.fetchOfInterface("parent interface"))).addToRepository(create.newEventGroup().withName("event group")).addToRepository(create.newInfrastructureInterface().withName("infrastructure interface")).addToRepository(create.newBasicComponent().withName("basic component").provides(create.fetchOfOperationInterface("interface"), "basic component provides interface").requires(create.fetchOfOperationInterface("interface"), "basic component requires interface").emits(create.fetchOfEventGroup("event group"), "emits event").handles(create.fetchOfEventGroup("event group"), "handles event").providesInfrastructure(create.fetchOfInfrastructureInterface("infrastructure interface"), "provides infrastructure").requiresInfrastructure(create.fetchOfInfrastructureInterface("infrastructure interface"), "requres infrastructure").requiresResource(ResourceInterface.CPU, "cpu interface").withServiceEffectSpecification(create.newSeff().onSignature(create.fetchOfSignature("signature")).withSeffBehaviour().withStartAction().followedBy().stopAction().createBehaviourNow())).addToRepository(create.newCompositeComponent().withAssemblyContext(create.fetchOfComponent("basic component"), "basic component context", new VariableUsageCreator[0]).withEventChannel(create.fetchOfEventGroup("event group")).withAssemblyConnection(create.fetchOfOperationProvidedRole("basic component provides interface"), create.fetchOfAssemblyContext("basic component context"), create.fetchOfOperationRequiredRole("basic component requires interface"), create.fetchOfAssemblyContext("basic component context"))).createRepositoryNow();
        ModelSaver.saveRepository(repository, "./", "miniExample");
    }

    public static void readmeExampleBackend() {
        RepositoryFactory repoFact = RepositoryFactory.eINSTANCE;
        Repository repository = repoFact.createRepository();
        BasicComponent databaseComponent = repoFact.createBasicComponent();
        databaseComponent.setEntityName("Database");
        OperationInterface databaseInterface = repoFact.createOperationInterface();
        databaseInterface.setEntityName("IDatabase");
        OperationSignature store = repoFact.createOperationSignature();
        store.setEntityName("store");
        Parameter forename = repoFact.createParameter();
        forename.setParameterName("forename");
        forename.setDataType__Parameter(null);
        Parameter name = repoFact.createParameter();
        name.setParameterName("forename");
        name.setDataType__Parameter(null);
        OperationProvidedRole dbProvIDb = repoFact.createOperationProvidedRole();
        dbProvIDb.setProvidedInterface__OperationProvidedRole(databaseInterface);
        dbProvIDb.setProvidingEntity_ProvidedRole((InterfaceProvidingEntity)databaseComponent);
        ResourceDemandingSEFF storeSeff = SeffFactory.eINSTANCE.createResourceDemandingSEFF();
        storeSeff.setDescribedService__SEFF((Signature)store);
        databaseComponent.getServiceEffectSpecifications__BasicComponent().add((Object)storeSeff);
        repository.getComponents__Repository().add((Object)databaseComponent);
        repository.getInterfaces__Repository().add((Object)databaseInterface);
        BasicComponent webComponent = repoFact.createBasicComponent();
        databaseComponent.setEntityName("Web");
        OperationInterface webInterface = repoFact.createOperationInterface();
        databaseInterface.setEntityName("IWeb");
        OperationSignature submit = repoFact.createOperationSignature();
        submit.setEntityName("submit");
        Parameter forename2 = repoFact.createParameter();
        forename2.setParameterName("forename");
        forename2.setDataType__Parameter(null);
        Parameter name2 = repoFact.createParameter();
        name2.setParameterName("forename");
        name2.setDataType__Parameter(null);
        OperationProvidedRole webProvIweb = repoFact.createOperationProvidedRole();
        webProvIweb.setProvidedInterface__OperationProvidedRole(webInterface);
        webProvIweb.setProvidingEntity_ProvidedRole((InterfaceProvidingEntity)webComponent);
        ResourceDemandingSEFF submitSeff = SeffFactory.eINSTANCE.createResourceDemandingSEFF();
        submitSeff.setDescribedService__SEFF((Signature)submit);
        webComponent.getServiceEffectSpecifications__BasicComponent().add((Object)submitSeff);
        OperationRequiredRole webRequIDb = repoFact.createOperationRequiredRole();
        webRequIDb.setRequiredInterface__OperationRequiredRole(databaseInterface);
        webRequIDb.setRequiringEntity_RequiredRole((InterfaceRequiringEntity)webComponent);
        repository.getComponents__Repository().add((Object)webComponent);
        repository.getInterfaces__Repository().add((Object)webInterface);
        ModelSaver.saveRepository(repository, "./", "backendExample");
    }

    public static void readmeExampleFluentAPI() {
        FluentRepositoryFactory create = new FluentRepositoryFactory();
        Repository repository = create.newRepository().addToRepository(create.newOperationInterface().withName("IDatabase").withOperationSignature(create.newOperationSignature().withName("store").withParameter("forename", Primitive.STRING, ParameterModifier.NONE).withParameter("name", Primitive.STRING, ParameterModifier.NONE))).addToRepository(create.newBasicComponent().withName("Database").withServiceEffectSpecification(create.newSeff().onSignature(create.fetchOfSignature("store"))).provides(create.fetchOfOperationInterface("IDatabase"))).addToRepository(create.newOperationInterface().withName("IWeb").withOperationSignature(create.newOperationSignature().withName("submit").withParameter("forename", Primitive.STRING, ParameterModifier.NONE).withParameter("name", Primitive.STRING, ParameterModifier.NONE))).addToRepository(create.newBasicComponent().withName("Web").withServiceEffectSpecification(create.newSeff().onSignature(create.fetchOfSignature("submit"))).provides(create.fetchOfOperationInterface("IWeb")).requires(create.fetchOfOperationInterface("IDatabase"))).createRepositoryNow();
        ModelSaver.saveRepository(repository, "./", "fluentAPIExample");
    }

    public static void presentationExample() {
        FluentRepositoryFactory create = new FluentRepositoryFactory();
        Repository repository = create.newRepository().addToRepository(create.newBasicComponent().withName("Database")).createRepositoryNow();
        ModelSaver.saveRepository(repository, "./", "fluentAPIExample");
    }

    public static void mediaStoreExample() {
        FluentRepositoryFactory create = new FluentRepositoryFactory();
        Repository mediaStore = create.newRepository().withName("MediaStoreRepository").addToRepository(create.newCompositeDataType().withName("FileContent")).addToRepository(create.newCompositeDataType().withName("AudioCollectionRequest").withInnerDeclaration("Count", Primitive.INTEGER).withInnerDeclaration("Size", Primitive.INTEGER)).addToRepository(create.newOperationInterface().withName("IFileStorage").withOperationSignature(create.newOperationSignature().withName("getFiles").withParameter("audioRequest", create.fetchOfDataType("AudioCollectionRequest"), ParameterModifier.NONE).withReturnType(create.fetchOfDataType("FileContent"))).withOperationSignature(create.newOperationSignature().withName("storeFile").withParameter("file", create.fetchOfDataType("FileContent"), null))).addToRepository(create.newOperationInterface().withName("IDownload").withOperationSignature(create.newOperationSignature().withName("download").withParameter("audioRequest", create.fetchOfDataType("AudioCollectionRequest"), ParameterModifier.NONE).withReturnType(create.fetchOfDataType("AudioCollectionRequest")))).addToRepository(create.newOperationInterface().withName("IMediaAccess").withOperationSignature(create.newOperationSignature().withName("upload").withParameter("file", create.fetchOfDataType("FileContent"), null)).withOperationSignature(create.newOperationSignature().withName("getFileList"))).addToRepository(create.newOperationInterface().withName("IPackaging").withOperationSignature(create.newOperationSignature().withName("zip").withParameter("audios", create.fetchOfDataType("AudioCollectionRequest"), null).withReturnType(create.fetchOfDataType("FileContent")))).addToRepository(create.newOperationInterface().withName("IMediaManagement").withOperationSignature(create.newOperationSignature().withName("upload").withParameter("file", create.fetchOfDataType("FileContent"), null)).withOperationSignature(create.newOperationSignature().withName("download").withParameter("audioRequest", create.fetchOfDataType("AudioCollectionRequest"), ParameterModifier.NONE).withReturnType(create.fetchOfDataType("FileContent"))).withOperationSignature(create.newOperationSignature().withName("getFileList"))).addToRepository(create.newBasicComponent().withName("EnqueueDownloadCache").provides(create.fetchOfOperationInterface("IDownload")).requires(create.fetchOfOperationInterface("IDownload")).withServiceEffectSpecification(create.newSeff())).addToRepository(create.newBasicComponent().withName("InstantDownloadCache").provides(create.fetchOfOperationInterface("IDownload")).requires(create.fetchOfOperationInterface("IDownload")).withServiceEffectSpecification(create.newSeff())).addToRepository(create.newBasicComponent().withName("FileStorage").provides(create.fetchOfOperationInterface("IFileStorage"), "IDataStorage").withServiceEffectSpecification(create.newSeff()).withServiceEffectSpecification(create.newSeff())).addToRepository(create.newBasicComponent().withName("MediaManagement").provides(create.fetchOfOperationInterface("IMediaManagement")).requires(create.fetchOfOperationInterface("IDownload")).requires(create.fetchOfOperationInterface("IPackaging")).requires(create.fetchOfOperationInterface("IMediaAccess")).withServiceEffectSpecification(create.newSeff()).withServiceEffectSpecification(create.newSeff()).withServiceEffectSpecification(create.newSeff())).addToRepository(create.newBasicComponent().withName("Packaging").provides(create.fetchOfOperationInterface("IPackaging")).withServiceEffectSpecification(create.newSeff())).addToRepository(create.newBasicComponent().withName("MediaAccess").provides(create.fetchOfOperationInterface("IMediaAccess")).provides(create.fetchOfOperationInterface("IDownload")).requires(create.fetchOfOperationInterface("IFileStorage"), "IDataStorage").withServiceEffectSpecification(create.newSeff()).withServiceEffectSpecification(create.newSeff()).withServiceEffectSpecification(create.newSeff())).createRepositoryNow();
        ModelSaver.saveRepository(mediaStore, "./", "myMediaStore");
    }

    public static void exampleWithoutMeaning() {
        FluentRepositoryFactory create = new FluentRepositoryFactory();
        Repository repository = create.newRepository().withName("defaultRepository").withDescription("This is my PCM model.").addToRepository(create.newCollectionDataType("StringList", Primitive.STRING)).addToRepository(create.newResourceTimeoutFailureType("blub")).addToRepository(create.newCompositeDataType().withName("Person").withInnerDeclaration("first names", create.fetchOfDataType("StringList")).withInnerDeclaration("age", Primitive.INTEGER)).addToRepository(create.newExceptionType().withName("myException").withExceptionMessage("FEHLER!")).addToRepository(create.newOperationInterface().withName("IDatabase").withOperationSignature(create.newOperationSignature().withName("saveDatabaseEntry").withParameter("first names", create.fetchOfDataType("StringList"), null).withParameter("age", Primitive.INTEGER, ParameterModifier.INOUT).withReturnType(create.fetchOfDataType("Person"))).withRequiredCharacterisation(create.fetchOfParameter("age"), VariableCharacterisationType.VALUE)).addToRepository(create.newEventGroup().withName("haha")).addToRepository(create.newBasicComponent().withName("Database").handles(create.newEventGroup().withName("hallo").withEventType(create.newEventType().withName("type").withParameter("foo", Primitive.BOOLEAN, null)).withRequiredCharacterisation(create.fetchOfParameter("foo"), VariableCharacterisationType.STRUCTURE)).withServiceEffectSpecification(create.newSeff().withSeffBehaviour().withStartAction().followedBy().externalCallAction().followedBy().stopAction().createBehaviourNow()).withPassiveResource("3", create.fetchOfResourceTimeoutFailureType("blub"), "passivo").provides(create.fetchOfOperationInterface("IDatabase"), "provDB").requires(create.newOperationInterface().withName("someInterface"), "reqSomeI").withPassiveResource("2*3", create.fetchOfResourceTimeoutFailureType("blub"), "passResource").withVariableUsage(create.newVariableUsage())).addToRepository(create.newBasicComponent().withName("Web2").provides(create.newOperationInterface().withName("IDatabase2"))).addToRepository(create.newCompositeComponent().withName("Web").withVariableUsage(create.newVariableUsage()).requires(create.newOperationInterface().withName("HelloWorld")).withAssemblyContext(create.fetchOfComponent("Database"), "DBContext", new VariableUsageCreator[0]).withAssemblyConnection(create.fetchOfOperationProvidedRole("provDB"), create.fetchOfAssemblyContext("DBContext"), create.fetchOfOperationRequiredRole("reqSomeI"), create.fetchOfAssemblyContext("DBContext")).withEventChannel(create.fetchOfEventGroup("haha"))).createRepositoryNow();
        ModelSaver.saveRepository(repository, "./", "meaninglessExample");
    }
}

