/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryEntity;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.EventGroupCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.InfrastructureInterfaceCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.OperationInterfaceCreator;
import org.palladiosimulator.pcm.core.entity.EntityFactory;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;
import org.palladiosimulator.pcm.resourcetype.ResourceInterface;

public abstract class Component
extends RepositoryEntity {
    protected List<ProvidedRole> providedRoles = new ArrayList<ProvidedRole>();
    protected List<RequiredRole> requiredRoles = new ArrayList<RequiredRole>();
    protected List<ResourceRequiredRole> resourceRequiredRoles = new ArrayList<ResourceRequiredRole>();

    public abstract RepositoryComponent build();

    public Component provides(OperationInterfaceCreator interfce) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        return this.provides(interfce, null);
    }

    public Component provides(OperationInterfaceCreator interfce, String name) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        OperationInterface i = interfce.build();
        this.repository.addInterface((Interface)i);
        return this.provides(i, name);
    }

    public Component provides(OperationInterface interfce) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        return this.provides(interfce, null);
    }

    public Component provides(OperationInterface interfce, String name) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        OperationProvidedRole providedRole = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        if (name != null) {
            providedRole.setEntityName(name);
        }
        providedRole.setProvidedInterface__OperationProvidedRole(interfce);
        this.providedRoles.add((ProvidedRole)providedRole);
        this.repository.addProvidedRole((ProvidedRole)providedRole);
        return this;
    }

    public Component providesInfrastructure(InfrastructureInterfaceCreator interfce) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        return this.providesInfrastructure(interfce, null);
    }

    public Component providesInfrastructure(InfrastructureInterfaceCreator interfce, String name) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        InfrastructureInterface i = interfce.build();
        this.repository.addInterface((Interface)i);
        return this.providesInfrastructure(i, name);
    }

    public Component providesInfrastructure(InfrastructureInterface interfce) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        return this.providesInfrastructure(interfce, null);
    }

    public Component providesInfrastructure(InfrastructureInterface interfce, String name) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        InfrastructureProvidedRole providedRole = RepositoryFactory.eINSTANCE.createInfrastructureProvidedRole();
        if (name != null) {
            providedRole.setEntityName(name);
        }
        providedRole.setProvidedInterface__InfrastructureProvidedRole(interfce);
        this.providedRoles.add((ProvidedRole)providedRole);
        this.repository.addProvidedRole((ProvidedRole)providedRole);
        return this;
    }

    public Component handles(EventGroupCreator eventGroup) {
        IllegalArgumentException.throwIfNull(eventGroup, "eventGroup must not be null");
        return this.handles(eventGroup, null);
    }

    public Component handles(EventGroupCreator eventGroup, String name) {
        IllegalArgumentException.throwIfNull(eventGroup, "eventGroup must not be null");
        EventGroup eg = eventGroup.build();
        this.repository.addInterface((Interface)eg);
        return this.handles(eg, name);
    }

    public Component handles(EventGroup eventGroup) {
        IllegalArgumentException.throwIfNull(eventGroup, "eventGroup must not be null");
        return this.handles(eventGroup, null);
    }

    public Component handles(EventGroup eventGroup, String name) {
        IllegalArgumentException.throwIfNull(eventGroup, "eventGroup must not be null");
        SinkRole providedRole = RepositoryFactory.eINSTANCE.createSinkRole();
        if (name != null) {
            providedRole.setEntityName(name);
        }
        providedRole.setEventGroup__SinkRole(eventGroup);
        this.providedRoles.add((ProvidedRole)providedRole);
        this.repository.addProvidedRole((ProvidedRole)providedRole);
        return this;
    }

    public Component requires(OperationInterfaceCreator interfce) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        return this.requires(interfce, null);
    }

    public Component requires(OperationInterfaceCreator interfce, String name) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        OperationInterface i = interfce.build();
        this.repository.addInterface((Interface)i);
        return this.requires(i, name);
    }

    public Component requires(OperationInterface interfce) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        return this.requires(interfce, null);
    }

    public Component requires(OperationInterface interfce, String name) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        OperationRequiredRole requiredRole = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
        if (name != null) {
            requiredRole.setEntityName(name);
        }
        requiredRole.setRequiredInterface__OperationRequiredRole(interfce);
        this.requiredRoles.add((RequiredRole)requiredRole);
        this.repository.addRequiredRole((RequiredRole)requiredRole);
        return this;
    }

    public Component requiresInfrastructure(InfrastructureInterfaceCreator interfce) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        return this.requiresInfrastructure(interfce, null);
    }

    public Component requiresInfrastructure(InfrastructureInterfaceCreator interfce, String name) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        InfrastructureInterface i = interfce.build();
        this.repository.addInterface((Interface)i);
        return this.requiresInfrastructure(i, name);
    }

    public Component requiresInfrastructure(InfrastructureInterface interfce) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        return this.requiresInfrastructure(interfce, null);
    }

    public Component requiresInfrastructure(InfrastructureInterface interfce, String name) {
        IllegalArgumentException.throwIfNull(interfce, "interfce must not be null");
        InfrastructureRequiredRole requiredRole = RepositoryFactory.eINSTANCE.createInfrastructureRequiredRole();
        if (name != null) {
            requiredRole.setEntityName(name);
        }
        requiredRole.setRequiredInterface__InfrastructureRequiredRole(interfce);
        this.requiredRoles.add((RequiredRole)requiredRole);
        this.repository.addRequiredRole((RequiredRole)requiredRole);
        return this;
    }

    public Component emits(EventGroupCreator eventGroup) {
        IllegalArgumentException.throwIfNull(eventGroup, "eventGroup must not be null");
        return this.emits(eventGroup, null);
    }

    public Component emits(EventGroupCreator eventGroup, String name) {
        IllegalArgumentException.throwIfNull(eventGroup, "eventGroup must not be null");
        EventGroup eg = eventGroup.build();
        this.repository.addInterface((Interface)eg);
        return this.emits(eg, name);
    }

    public Component emits(EventGroup eventGroup) {
        IllegalArgumentException.throwIfNull(eventGroup, "eventGroup must not be null");
        return this.emits(eventGroup, null);
    }

    public Component emits(EventGroup eventGroup, String name) {
        IllegalArgumentException.throwIfNull(eventGroup, "eventGroup must not be null");
        SourceRole requiredRole = RepositoryFactory.eINSTANCE.createSourceRole();
        if (name != null) {
            requiredRole.setEntityName(name);
        }
        requiredRole.setEventGroup__SourceRole(eventGroup);
        this.requiredRoles.add((RequiredRole)requiredRole);
        this.repository.addRequiredRole((RequiredRole)requiredRole);
        return this;
    }

    public Component requiresResource(org.palladiosimulator.generator.fluent.shared.structure.ResourceInterface resourceInterface) {
        IllegalArgumentException.throwIfNull(resourceInterface, "resourceInterface must not be null");
        return this.requiresResource(resourceInterface, null);
    }

    public Component requiresResource(org.palladiosimulator.generator.fluent.shared.structure.ResourceInterface resourceInterface, String name) {
        IllegalArgumentException.throwIfNull(resourceInterface, "resourceInterface must not be null");
        ResourceRequiredRole rrr = EntityFactory.eINSTANCE.createResourceRequiredRole();
        if (name != null) {
            rrr.setEntityName(name);
        }
        ResourceInterface resInt = this.repository.getResourceInterface(resourceInterface);
        rrr.setRequiredResourceInterface__ResourceRequiredRole(resInt);
        this.resourceRequiredRoles.add(rrr);
        this.repository.addResourceRequiredRole(rrr);
        return this;
    }
}

