/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.Collection;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.api.seff.Seff;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.GeneralAction;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.ResourceSignature;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;

public class CollectionIteratorActionCreator
extends GeneralAction {
    private Parameter parameter;
    private Seff loopBody;

    protected CollectionIteratorActionCreator(SeffCreator seff) {
        this.seff = seff;
    }

    @Override
    public CollectionIteratorActionCreator withName(String name) {
        return (CollectionIteratorActionCreator)super.withName(name);
    }

    public CollectionIteratorActionCreator withParameter(Parameter parameter) {
        IllegalArgumentException.throwIfNull(parameter, "parameter must not be null");
        this.parameter = parameter;
        return this;
    }

    public CollectionIteratorActionCreator withLoopBody(Seff loopBody) {
        IllegalArgumentException.throwIfNull(loopBody, "loopBody must not be null");
        this.loopBody = loopBody;
        return this;
    }

    @Override
    public CollectionIteratorActionCreator withResourceDemand(String specificationStochasticExpression, ProcessingResource processingResource) {
        return (CollectionIteratorActionCreator)super.withResourceDemand(specificationStochasticExpression, processingResource);
    }

    @Override
    public CollectionIteratorActionCreator withInfrastructureCall(String numberOfCallsStochasticExpression, InfrastructureSignature signature, InfrastructureRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (CollectionIteratorActionCreator)super.withInfrastructureCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    @Override
    public CollectionIteratorActionCreator withResourceCall(String numberOfCallsStochasticExpression, ResourceSignature signature, ResourceRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (CollectionIteratorActionCreator)super.withResourceCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    protected CollectionIteratorAction build() {
        CollectionIteratorAction action = SeffFactory.eINSTANCE.createCollectionIteratorAction();
        if (this.name != null) {
            action.setEntityName(this.name);
        }
        if (this.parameter != null) {
            action.setParameter_CollectionIteratorAction(this.parameter);
        }
        if (this.loopBody != null) {
            ResourceDemandingSEFF build = this.loopBody.buildRDSeff();
            if (build.getDescribedService__SEFF() == null && build.getResourceDemandingInternalBehaviours().isEmpty()) {
                action.setBodyBehaviour_Loop(this.loopBody.buildBehaviour());
            } else {
                action.setBodyBehaviour_Loop((ResourceDemandingBehaviour)build);
            }
        }
        action.getInfrastructureCall__Action().addAll((Collection)this.infrastructureCalls);
        action.getResourceCall__Action().addAll((Collection)this.resourceCalls);
        action.getResourceDemand_Action().addAll((Collection)this.demands);
        return action;
    }
}

