/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.SystemEntity;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.repository.RepositoryComponent;

public class AssemblyContextCreator
extends SystemEntity {
    private RepositoryComponent encapuslatedComponent;

    public AssemblyContextCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public AssemblyContextCreator withEncapsulatedComponent(RepositoryComponent component) {
        IllegalArgumentException.throwIfNull(component, "The given RepositoryComponent must not be null.");
        this.encapuslatedComponent = component;
        return this;
    }

    public AssemblyContextCreator withEncapsulatedComponent(String name) throws NoSuchElementException {
        RepositoryComponent component = this.system.getRepositoryComponentByName(name);
        return this.withEncapsulatedComponent(component);
    }

    public AssemblyContext build() {
        AssemblyContext context = CompositionFactory.eINSTANCE.createAssemblyContext();
        if (this.name != null) {
            context.setEntityName(this.name);
        }
        if (this.encapuslatedComponent != null) {
            context.setEncapsulatedComponent__AssemblyContext(this.encapuslatedComponent);
        }
        return context;
    }

    @Override
    public AssemblyContextCreator withName(String name) {
        return (AssemblyContextCreator)super.withName(name);
    }
}

