/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.ScenarioBehaviourCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.ActionCreator;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;

public class LoopActionCreator
extends ActionCreator {
    private PCMRandomVariable iteration;
    private ScenarioBehaviour bodyBehav;

    public LoopActionCreator(String iteration, ScenarioBehaviourCreator bodyBehaviour) {
        this.addToLoopAction(iteration);
        this.addToLoopAction(bodyBehaviour);
    }

    private LoopActionCreator addToLoopAction(ScenarioBehaviourCreator bodyBehaviour) {
        IllegalArgumentException.throwIfNull(bodyBehaviour, "The given body Behavoiur must not be null");
        this.bodyBehav = bodyBehaviour.build();
        return this;
    }

    private LoopActionCreator addToLoopAction(String iteration) {
        IllegalArgumentException.throwIfNull(iteration, "The given Iteration must not be null");
        this.iteration = CoreFactory.eINSTANCE.createPCMRandomVariable();
        this.iteration.setSpecification(iteration);
        return this;
    }

    public Loop build() {
        Loop loop = UsagemodelFactory.eINSTANCE.createLoop();
        if (this.bodyBehav != null) {
            loop.setBodyBehaviour_Loop(this.bodyBehav);
        }
        if (this.iteration != null) {
            loop.setLoopIteration_Loop(this.iteration);
        }
        if (this.name != null) {
            loop.setEntityName(this.name);
        }
        if (this.successor != null) {
            loop.setSuccessor(this.successor);
        }
        return loop;
    }

    @Override
    public LoopActionCreator withSuccessor(ActionCreator action) {
        return (LoopActionCreator)super.withSuccessor(action);
    }

    @Override
    public LoopActionCreator withName(String name) {
        return (LoopActionCreator)super.withName(name);
    }
}

