/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.allocation.structure;

import org.palladiosimulator.generator.fluent.allocation.structure.AllocationCreator;
import org.palladiosimulator.generator.fluent.allocation.structure.AllocationEntity;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.EventChannel;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;

public class AllocationContextCreator
extends AllocationEntity {
    private AssemblyContext assemblyContext;
    private EventChannel eventChannel;
    private ResourceContainer resourceContainer;

    public AllocationContextCreator(AllocationCreator allocationCreator) {
        this.allocationCreator = allocationCreator;
    }

    public AllocationContextCreator withAssemblyContext(AssemblyContext context) {
        this.assemblyContext = IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return this;
    }

    public AllocationContextCreator withAssemblyContext(String name) throws IllegalArgumentException {
        return this.withAssemblyContext(this.allocationCreator.getAssemblyContextByName(name));
    }

    public AllocationContextCreator withEventChannel(EventChannel channel) {
        this.eventChannel = IllegalArgumentException.throwIfNull(channel, "The given EventChannel must not be null");
        return this;
    }

    public AllocationContextCreator withEventChannel(String name) throws IllegalArgumentException {
        return this.withEventChannel(this.allocationCreator.getEventChannelByName(name));
    }

    public AllocationContextCreator withResourceContainer(ResourceContainer container) {
        this.resourceContainer = IllegalArgumentException.throwIfNull(container, "The given ResourceContainer must not be null");
        return this;
    }

    public AllocationContextCreator withResourceContainer(String name) throws IllegalArgumentException {
        return this.withResourceContainer(this.allocationCreator.getResourceContainerByName(name));
    }

    protected AllocationContext build() {
        AllocationContext context = AllocationFactory.eINSTANCE.createAllocationContext();
        if (this.name != null) {
            context.setEntityName(this.name);
        }
        context.setAssemblyContext_AllocationContext(this.assemblyContext);
        context.setEventChannel__AllocationContext(this.eventChannel);
        context.setResourceContainer_AllocationContext(this.resourceContainer);
        return context;
    }

    @Override
    public AllocationContextCreator withName(String name) {
        return (AllocationContextCreator)super.withName(name);
    }
}

