/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.components.Component;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyEventConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.EventChannel;
import org.palladiosimulator.pcm.core.composition.EventChannelSinkConnector;
import org.palladiosimulator.pcm.core.composition.EventChannelSourceConnector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.ProvidedInfrastructureDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredInfrastructureDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredResourceDelegationConnector;
import org.palladiosimulator.pcm.core.composition.ResourceRequiredDelegationConnector;
import org.palladiosimulator.pcm.core.composition.SinkDelegationConnector;
import org.palladiosimulator.pcm.core.composition.SourceDelegationConnector;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;

public abstract class ComplexComponent
extends Component {
    protected List<AssemblyContext> assemblyContexts = new ArrayList<AssemblyContext>();
    protected List<Connector> connectors = new ArrayList<Connector>();
    protected List<EventChannel> eventChannels = new ArrayList<EventChannel>();
    protected List<ResourceRequiredDelegationConnector> resourceRequiredDelegationConnectors = new ArrayList<ResourceRequiredDelegationConnector>();

    public ComplexComponent withAssemblyContext(RepositoryComponent encapsulatedComponent, String name, VariableUsageCreator ... configParameterUsages) {
        IllegalArgumentException.throwIfNull(encapsulatedComponent, "encapsulatedComponent must not be null");
        IllegalArgumentException.throwIfNull(configParameterUsages, "config parameter usages must not be null");
        if (configParameterUsages.length > 0) {
            VariableUsageCreator[] variableUsageCreatorArray = configParameterUsages;
            int n = configParameterUsages.length;
            int n2 = 0;
            while (n2 < n) {
                VariableUsageCreator configParameterUsage = variableUsageCreatorArray[n2];
                IllegalArgumentException.throwIfNull(configParameterUsage, "config parameter usages must not be null");
                ++n2;
            }
        }
        AssemblyContext ac = CompositionFactory.eINSTANCE.createAssemblyContext();
        if (name != null) {
            ac.setEntityName(name);
        }
        ac.setEncapsulatedComponent__AssemblyContext(encapsulatedComponent);
        Arrays.asList(configParameterUsages).stream().map(VariableUsageCreator::build).forEach(v -> {
            boolean bl = ac.getConfigParameterUsages__AssemblyContext().add(v);
        });
        this.assemblyContexts.add(ac);
        this.repository.addAssemblyContext(ac);
        return this;
    }

    public ComplexComponent withAssemblyContext(RepositoryComponent encapsulatedComponent, VariableUsageCreator ... configParameterUsages) {
        return this.withAssemblyContext(encapsulatedComponent, (String)null, configParameterUsages);
    }

    public ComplexComponent withEventChannel(EventGroup eventGroup, String name) {
        IllegalArgumentException.throwIfNull(eventGroup, "eventGroup must not be null");
        EventChannel eventChannel = CompositionFactory.eINSTANCE.createEventChannel();
        if (name != null) {
            eventChannel.setEntityName(name);
        }
        eventChannel.setEventGroup__EventChannel(eventGroup);
        this.eventChannels.add(eventChannel);
        return this;
    }

    public ComplexComponent withEventChannel(EventGroup eventGroup) {
        return this.withEventChannel(eventGroup, null);
    }

    public ComplexComponent withAssemblyConnection(OperationProvidedRole providedRole, AssemblyContext providingAssemblyContext, OperationRequiredRole requiredRole, AssemblyContext requiringAssemblyContext) {
        IllegalArgumentException.throwIfNull(providedRole, "providedRole must not be null");
        IllegalArgumentException.throwIfNull(providingAssemblyContext, "providingAssemblyContext must not be null");
        IllegalArgumentException.throwIfNull(requiredRole, "requiredRole must not be null");
        IllegalArgumentException.throwIfNull(requiringAssemblyContext, "requiringAssemblyContext must not be null");
        AssemblyConnector assemblyConnector = CompositionFactory.eINSTANCE.createAssemblyConnector();
        assemblyConnector.setProvidedRole_AssemblyConnector(providedRole);
        assemblyConnector.setProvidingAssemblyContext_AssemblyConnector(providingAssemblyContext);
        assemblyConnector.setRequiredRole_AssemblyConnector(requiredRole);
        assemblyConnector.setRequiringAssemblyContext_AssemblyConnector(requiringAssemblyContext);
        this.connectors.add((Connector)assemblyConnector);
        return this;
    }

    public ComplexComponent withProvidedDelegationConnection(AssemblyContext assemblyContext, OperationProvidedRole innerProvidedRole, OperationProvidedRole outerProvidedRole) {
        IllegalArgumentException.throwIfNull(assemblyContext, "assemblyContext must not be null");
        IllegalArgumentException.throwIfNull(innerProvidedRole, "innerProvidedRole must not be null");
        IllegalArgumentException.throwIfNull(outerProvidedRole, "outerProvidedRole must not be null");
        ProvidedDelegationConnector connector = CompositionFactory.eINSTANCE.createProvidedDelegationConnector();
        connector.setAssemblyContext_ProvidedDelegationConnector(assemblyContext);
        connector.setInnerProvidedRole_ProvidedDelegationConnector(innerProvidedRole);
        connector.setOuterProvidedRole_ProvidedDelegationConnector(outerProvidedRole);
        this.connectors.add((Connector)connector);
        return this;
    }

    public ComplexComponent withRequiredDelegationConnection(AssemblyContext assemblyContext, OperationRequiredRole innerRequiredRole, OperationRequiredRole outerRequiredRole) {
        IllegalArgumentException.throwIfNull(assemblyContext, "assemblyContext must not be null");
        IllegalArgumentException.throwIfNull(innerRequiredRole, "innerRequiredRole must not be null");
        IllegalArgumentException.throwIfNull(outerRequiredRole, "outerRequiredRole must not be null");
        RequiredDelegationConnector connector = CompositionFactory.eINSTANCE.createRequiredDelegationConnector();
        connector.setAssemblyContext_RequiredDelegationConnector(assemblyContext);
        connector.setInnerRequiredRole_RequiredDelegationConnector(innerRequiredRole);
        connector.setOuterRequiredRole_RequiredDelegationConnector(outerRequiredRole);
        this.connectors.add((Connector)connector);
        return this;
    }

    public ComplexComponent withAssemblyEventConnection(SinkRole sinkRole, AssemblyContext sinkAssemblyContext, SourceRole sourceRole, AssemblyContext sourceAssemblyContext, String filterConditionStochasticExpression) {
        IllegalArgumentException.throwIfNull(sinkRole, "sinkRole must not be null");
        IllegalArgumentException.throwIfNull(sinkAssemblyContext, "sinkAssemblyContext must not be null");
        IllegalArgumentException.throwIfNull(sourceRole, "sourceRole must not be null");
        IllegalArgumentException.throwIfNull(sourceAssemblyContext, "sourceAssemblyContext must not be null");
        IllegalArgumentException.throwIfNull(filterConditionStochasticExpression, "filterCondition_stochasticExpression must not be null");
        AssemblyEventConnector connector = CompositionFactory.eINSTANCE.createAssemblyEventConnector();
        connector.setSinkRole__AssemblyEventConnector(sinkRole);
        connector.setSinkAssemblyContext__AssemblyEventConnector(sinkAssemblyContext);
        connector.setSourceRole__AssemblyEventConnector(sourceRole);
        connector.setSourceAssemblyContext__AssemblyEventConnector(sourceAssemblyContext);
        PCMRandomVariable rand = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rand.setSpecification(filterConditionStochasticExpression);
        connector.setFilterCondition__AssemblyEventConnector(rand);
        this.connectors.add((Connector)connector);
        return this;
    }

    public ComplexComponent withEventChannelSinkConnection(AssemblyContext assemblyContext, EventChannel eventChannel, SinkRole sinkRole, String filterConditionStochasticExpression) {
        IllegalArgumentException.throwIfNull(assemblyContext, "assemblyContext must not be null");
        IllegalArgumentException.throwIfNull(eventChannel, "eventChannel must not be null");
        IllegalArgumentException.throwIfNull(sinkRole, "sinkRole must not be null");
        IllegalArgumentException.throwIfNull(filterConditionStochasticExpression, "filterCondition_stochasticExpression must not be null");
        EventChannelSinkConnector connector = CompositionFactory.eINSTANCE.createEventChannelSinkConnector();
        connector.setAssemblyContext__EventChannelSinkConnector(assemblyContext);
        connector.setEventChannel__EventChannelSinkConnector(eventChannel);
        connector.setSinkRole__EventChannelSinkConnector(sinkRole);
        connector.setEntityName(this.name);
        PCMRandomVariable rand = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rand.setSpecification(filterConditionStochasticExpression);
        connector.setFilterCondition__EventChannelSinkConnector(rand);
        this.connectors.add((Connector)connector);
        return this;
    }

    public ComplexComponent withEventChannelSourceConnection(AssemblyContext assemblyContext, EventChannel eventChannel, SourceRole sourceRole) {
        IllegalArgumentException.throwIfNull(assemblyContext, "assemblyContext must not be null");
        IllegalArgumentException.throwIfNull(eventChannel, "eventChannel must not be null");
        IllegalArgumentException.throwIfNull(sourceRole, "sourceRole must not be null");
        EventChannelSourceConnector connector = CompositionFactory.eINSTANCE.createEventChannelSourceConnector();
        connector.setAssemblyContext__EventChannelSourceConnector(assemblyContext);
        connector.setEventChannel__EventChannelSourceConnector(eventChannel);
        connector.setSourceRole__EventChannelSourceRole(sourceRole);
        connector.setEntityName(this.name);
        this.connectors.add((Connector)connector);
        return this;
    }

    public ComplexComponent withSinkDelegationConnection(AssemblyContext assemblyContext, SinkRole innerSinkRole, SinkRole outerSinkRole) {
        IllegalArgumentException.throwIfNull(assemblyContext, "assemblyContext must not be null");
        IllegalArgumentException.throwIfNull(innerSinkRole, "innerSinkRole must not be null");
        IllegalArgumentException.throwIfNull(outerSinkRole, "outerSinkRole must not be null");
        SinkDelegationConnector connector = CompositionFactory.eINSTANCE.createSinkDelegationConnector();
        connector.setAssemblyContext__SinkDelegationConnector(assemblyContext);
        connector.setInnerSinkRole__SinkRole(innerSinkRole);
        connector.setOuterSinkRole__SinkRole(outerSinkRole);
        this.connectors.add((Connector)connector);
        return this;
    }

    public ComplexComponent withSourceDelegationConnection(AssemblyContext assemblyContext, SourceRole innerSourceRole, SourceRole outerSourceRole) {
        IllegalArgumentException.throwIfNull(assemblyContext, "assemblyContext must not be null");
        IllegalArgumentException.throwIfNull(innerSourceRole, "innerSourceRole must not be null");
        IllegalArgumentException.throwIfNull(outerSourceRole, "outerSourceRole must not be null");
        SourceDelegationConnector connector = CompositionFactory.eINSTANCE.createSourceDelegationConnector();
        connector.setAssemblyContext__SourceDelegationConnector(assemblyContext);
        connector.setInnerSourceRole__SourceRole(innerSourceRole);
        connector.setOuterSourceRole__SourceRole(outerSourceRole);
        this.connectors.add((Connector)connector);
        return this;
    }

    public ComplexComponent withAssemblyInfrastructureConnection(InfrastructureProvidedRole providedRole, AssemblyContext providingAssemblyContext, InfrastructureRequiredRole requiredRole, AssemblyContext requiringAssemblyContext) {
        IllegalArgumentException.throwIfNull(providedRole, "providedRole must not be null");
        IllegalArgumentException.throwIfNull(providingAssemblyContext, "providingAssemblyContext must not be null");
        IllegalArgumentException.throwIfNull(requiredRole, "requiredRole must not be null");
        IllegalArgumentException.throwIfNull(requiringAssemblyContext, "requiringAssemblyContext must not be null");
        AssemblyInfrastructureConnector connector = CompositionFactory.eINSTANCE.createAssemblyInfrastructureConnector();
        connector.setProvidedRole__AssemblyInfrastructureConnector(providedRole);
        connector.setProvidingAssemblyContext__AssemblyInfrastructureConnector(providingAssemblyContext);
        connector.setRequiredRole__AssemblyInfrastructureConnector(requiredRole);
        connector.setRequiringAssemblyContext__AssemblyInfrastructureConnector(requiringAssemblyContext);
        this.connectors.add((Connector)connector);
        return this;
    }

    public ComplexComponent withProvidedInfrastructureDelegationConnection(AssemblyContext assemblyContext, InfrastructureProvidedRole innerProvidedRole, InfrastructureProvidedRole outerProvidedRole) {
        IllegalArgumentException.throwIfNull(assemblyContext, "assemblyContext must not be null");
        IllegalArgumentException.throwIfNull(innerProvidedRole, "innerProvidedRole must not be null");
        IllegalArgumentException.throwIfNull(outerProvidedRole, "outerProvidedRole must not be null");
        ProvidedInfrastructureDelegationConnector connector = CompositionFactory.eINSTANCE.createProvidedInfrastructureDelegationConnector();
        connector.setAssemblyContext__ProvidedInfrastructureDelegationConnector(assemblyContext);
        connector.setInnerProvidedRole__ProvidedInfrastructureDelegationConnector(innerProvidedRole);
        connector.setOuterProvidedRole__ProvidedInfrastructureDelegationConnector(outerProvidedRole);
        this.connectors.add((Connector)connector);
        return this;
    }

    public ComplexComponent withRequiredInfrastructureDelegationConnection(AssemblyContext assemblyContext, InfrastructureRequiredRole innerRequiredRole, InfrastructureRequiredRole outerRequiredRole) {
        IllegalArgumentException.throwIfNull(assemblyContext, "assemblyContext must not be null");
        IllegalArgumentException.throwIfNull(innerRequiredRole, "innerRequiredRole must not be null");
        IllegalArgumentException.throwIfNull(outerRequiredRole, "outerRequiredRole must not be null");
        RequiredInfrastructureDelegationConnector connector = CompositionFactory.eINSTANCE.createRequiredInfrastructureDelegationConnector();
        connector.setAssemblyContext__RequiredInfrastructureDelegationConnector(assemblyContext);
        connector.setInnerRequiredRole__RequiredInfrastructureDelegationConnector(innerRequiredRole);
        connector.setOuterRequiredRole__RequiredInfrastructureDelegationConnector(outerRequiredRole);
        this.connectors.add((Connector)connector);
        return this;
    }

    public ComplexComponent withRequiredResourceDelegationConnection(AssemblyContext assemblyContext, ResourceRequiredRole innerRequiredRole, ResourceRequiredRole outerRequiredRole) {
        IllegalArgumentException.throwIfNull(assemblyContext, "assemblyContext must not be null");
        IllegalArgumentException.throwIfNull(innerRequiredRole, "innerRequiredRole must not be null");
        IllegalArgumentException.throwIfNull(outerRequiredRole, "outerRequiredRole must not be null");
        RequiredResourceDelegationConnector connector = CompositionFactory.eINSTANCE.createRequiredResourceDelegationConnector();
        connector.setAssemblyContext__RequiredResourceDelegationConnector(assemblyContext);
        connector.setInnerRequiredRole__RequiredResourceDelegationConnector(innerRequiredRole);
        connector.setOuterRequiredRole__RequiredResourceDelegationConnector(outerRequiredRole);
        this.connectors.add((Connector)connector);
        return this;
    }

    public ComplexComponent resourceRequiredDegelationConnection(ResourceRequiredRole innerRequiredRole, ResourceRequiredRole outerRequiredRole) {
        IllegalArgumentException.throwIfNull(innerRequiredRole, "innerRequiredRole must not be null");
        IllegalArgumentException.throwIfNull(outerRequiredRole, "outerRequiredRole must not be null");
        ResourceRequiredDelegationConnector connector = CompositionFactory.eINSTANCE.createResourceRequiredDelegationConnector();
        connector.setInnerResourceRequiredRole_ResourceRequiredDelegationConnector(innerRequiredRole);
        connector.setOuterResourceRequiredRole_ResourceRequiredDelegationConnector(outerRequiredRole);
        this.resourceRequiredDelegationConnectors.add(connector);
        return this;
    }

    protected void addEventChannel(EventChannel eventChannel) {
        this.eventChannels.add(eventChannel);
    }
}

