/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.api.seff.InternalSeff;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.GeneralAction;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.ResourceSignature;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.seff.InternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingInternalBehaviour;
import org.palladiosimulator.pcm.seff.SeffFactory;

public class InternalCallActionCreator
extends GeneralAction {
    private final List<VariableUsage> inputVariableUsages;
    private InternalSeff internalSeff;

    protected InternalCallActionCreator(SeffCreator seff) {
        this.seff = seff;
        this.demands = new ArrayList();
        this.infrastructureCalls = new ArrayList();
        this.resourceCalls = new ArrayList();
        this.inputVariableUsages = new ArrayList<VariableUsage>();
    }

    @Override
    public InternalCallActionCreator withName(String name) {
        return (InternalCallActionCreator)super.withName(name);
    }

    public InternalCallActionCreator withInputVaribleUsage(VariableUsageCreator variableUsage) {
        IllegalArgumentException.throwIfNull(variableUsage, "variableUsage must not be null");
        this.inputVariableUsages.add(variableUsage.build());
        return this;
    }

    public InternalCallActionCreator withInternalBehaviour(InternalSeff internalBehaviour) {
        IllegalArgumentException.throwIfNull(internalBehaviour, "internalBehaviour must not be null");
        this.internalSeff = internalBehaviour;
        return this;
    }

    @Override
    public InternalCallActionCreator withResourceDemand(String specificationStochasticExpression, ProcessingResource processingResource) {
        return (InternalCallActionCreator)super.withResourceDemand(specificationStochasticExpression, processingResource);
    }

    @Override
    public InternalCallActionCreator withInfrastructureCall(String numberOfCallsStochasticExpression, InfrastructureSignature signature, InfrastructureRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (InternalCallActionCreator)super.withInfrastructureCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    @Override
    public InternalCallActionCreator withResourceCall(String numberOfCallsStochasticExpression, ResourceSignature signature, ResourceRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (InternalCallActionCreator)super.withResourceCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    protected InternalCallAction build() {
        InternalCallAction action = SeffFactory.eINSTANCE.createInternalCallAction();
        if (this.name != null) {
            action.setEntityName(this.name);
        }
        if (this.internalSeff != null) {
            ResourceDemandingInternalBehaviour internal = this.internalSeff.buildInternalBehaviour();
            action.setCalledResourceDemandingInternalBehaviour(internal);
        }
        action.getInputVariableUsages__CallAction().addAll(this.inputVariableUsages);
        action.getResourceDemand_Action().addAll((Collection)this.demands);
        action.getInfrastructureCall__Action().addAll((Collection)this.infrastructureCalls);
        action.getResourceCall__Action().addAll((Collection)this.resourceCalls);
        return action;
    }
}

