/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.Collection;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.api.seff.Seff;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.GeneralAction;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.ResourceSignature;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;

public class LoopActionCreator
extends GeneralAction {
    private PCMRandomVariable iterationCount;
    private Seff loopBody;

    protected LoopActionCreator(SeffCreator seff) {
        this.seff = seff;
    }

    @Override
    public LoopActionCreator withName(String name) {
        return (LoopActionCreator)super.withName(name);
    }

    public LoopActionCreator withIterationCount(String iterationCountStochasticExpression) {
        IllegalArgumentException.throwIfNull(iterationCountStochasticExpression, "iterationCount_stochasticExpression must not be null");
        PCMRandomVariable rand = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rand.setSpecification(iterationCountStochasticExpression);
        this.iterationCount = rand;
        return this;
    }

    public LoopActionCreator withLoopBody(Seff loopBody) {
        IllegalArgumentException.throwIfNull(loopBody, "loopBody must not be null");
        this.loopBody = loopBody;
        return this;
    }

    @Override
    public LoopActionCreator withResourceDemand(String specificationStochasticExpression, ProcessingResource processingResource) {
        return (LoopActionCreator)super.withResourceDemand(specificationStochasticExpression, processingResource);
    }

    @Override
    public LoopActionCreator withInfrastructureCall(String numberOfCallsStochasticExpression, InfrastructureSignature signature, InfrastructureRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (LoopActionCreator)super.withInfrastructureCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    @Override
    public LoopActionCreator withResourceCall(String numberOfCallsStochasticExpression, ResourceSignature signature, ResourceRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (LoopActionCreator)super.withResourceCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    protected LoopAction build() {
        LoopAction action = SeffFactory.eINSTANCE.createLoopAction();
        if (this.name != null) {
            action.setEntityName(this.name);
        }
        action.setIterationCount_LoopAction(this.iterationCount);
        if (this.loopBody != null) {
            ResourceDemandingSEFF build = this.loopBody.buildRDSeff();
            if (build.getDescribedService__SEFF() == null && build.getResourceDemandingInternalBehaviours().isEmpty()) {
                action.setBodyBehaviour_Loop(this.loopBody.buildBehaviour());
            } else {
                action.setBodyBehaviour_Loop((ResourceDemandingBehaviour)build);
            }
        }
        action.getInfrastructureCall__Action().addAll((Collection)this.infrastructureCalls);
        action.getResourceCall__Action().addAll((Collection)this.resourceCalls);
        action.getResourceDemand_Action().addAll((Collection)this.demands);
        return action;
    }
}

