/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.Collection;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.GeneralAction;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.ResourceSignature;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.SeffFactory;

public class ReleaseActionCreator
extends GeneralAction {
    private PassiveResource passiveResource;

    protected ReleaseActionCreator(SeffCreator seff) {
        this.seff = seff;
    }

    @Override
    public ReleaseActionCreator withName(String name) {
        return (ReleaseActionCreator)super.withName(name);
    }

    public ReleaseActionCreator withPassiveResource(PassiveResource passiveResource) {
        IllegalArgumentException.throwIfNull(passiveResource, "passiveResource must not be null");
        this.passiveResource = passiveResource;
        return this;
    }

    @Override
    public ReleaseActionCreator withResourceDemand(String specificationStochasticExpression, ProcessingResource processingResource) {
        return (ReleaseActionCreator)super.withResourceDemand(specificationStochasticExpression, processingResource);
    }

    @Override
    public ReleaseActionCreator withInfrastructureCall(String numberOfCallsStochasticExpression, InfrastructureSignature signature, InfrastructureRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (ReleaseActionCreator)super.withInfrastructureCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    @Override
    public ReleaseActionCreator withResourceCall(String numberOfCallsStochasticExpression, ResourceSignature signature, ResourceRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (ReleaseActionCreator)super.withResourceCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    protected ReleaseAction build() {
        ReleaseAction action = SeffFactory.eINSTANCE.createReleaseAction();
        if (this.name != null) {
            action.setEntityName(this.name);
        }
        if (this.passiveResource != null) {
            action.setPassiveResource_ReleaseAction(this.passiveResource);
        }
        action.getInfrastructureCall__Action().addAll((Collection)this.infrastructureCalls);
        action.getResourceCall__Action().addAll((Collection)this.resourceCalls);
        action.getResourceDemand_Action().addAll((Collection)this.demands);
        return action;
    }
}

