/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.shared.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.palladiosimulator.generator.fluent.exceptions.FluentApiException;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.resourcetype.ResourcetypePackage;
import org.palladiosimulator.pcm.system.System;

public class ModelLoader {
    public static final String FAILURE_TYPES_PATH = "pathmap://PCM_MODELS/FailureTypes.repository";
    public static final String PRIMITIVE_TYPES_PATH = "pathmap://PCM_MODELS/PrimitiveTypes.repository";
    public static final String RESOURCE_TYPE_PATH = "pathmap://PCM_MODELS/Palladio.resourcetype";

    private static EObject load(String uri, String extension) {
        if (uri == null || uri.isBlank() || extension == null || extension.isBlank()) {
            throw new FluentApiException("The elements of the URI where the model will be loaded with the specified extension must not be blank.");
        }
        ResourcetypePackage.eINSTANCE.eClass();
        Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
        String[] stringArray = new String[]{extension.strip(), "xmi"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fe = stringArray[n2];
            registry.getExtensionToFactoryMap().put(fe, new XMIResourceFactoryImpl());
            ++n2;
        }
        Resource resource = new ResourceSetImpl().getResource(URI.createURI((String)uri.strip()), true);
        return (EObject)resource.getContents().get(0);
    }

    public static Allocation loadAllocation(String uri) {
        return (Allocation)ModelLoader.load(uri, "allocation");
    }

    public static Repository loadRepository(String uri) {
        return (Repository)ModelLoader.load(uri, "repository");
    }

    public static ResourceEnvironment loadResourceEnvironment(String uri) {
        return (ResourceEnvironment)ModelLoader.load(uri, "resourceenvironment");
    }

    public static ResourceRepository loadResourceTypeRepository(String uri) {
        return (ResourceRepository)ModelLoader.load(uri, "resourcetype");
    }

    public static System loadSystem(String uri) {
        return (System)ModelLoader.load(uri, "system");
    }

    private ModelLoader() throws IllegalAccessException {
        throw new IllegalAccessException();
    }
}

