/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.infrastructure;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.infrastructure.InfrastructureProvidedRoleSelector;
import org.palladiosimulator.generator.fluent.system.structure.connector.infrastructure.InfrastructureRequiredRoleSelector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;

public class AssemblyInfrastructureConnectorCreator
extends AbstractConnectorCreator {
    private AssemblyContext requiringContext;
    private InfrastructureRequiredRole requiredRole;
    private AssemblyContext providingContext;
    private InfrastructureProvidedRole providedRole;

    public AssemblyInfrastructureConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public InfrastructureRequiredRoleSelector<AssemblyInfrastructureConnectorCreator> withRequiringAssemblyContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return new InfrastructureRequiredRoleSelector<AssemblyInfrastructureConnectorCreator>((reqContext, role) -> {
            this.requiringContext = reqContext;
            this.requiredRole = role;
            return this;
        }, context);
    }

    public InfrastructureRequiredRoleSelector<AssemblyInfrastructureConnectorCreator> withRequiringAssemblyContext(String name) {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withRequiringAssemblyContext(context);
    }

    public InfrastructureProvidedRoleSelector<AssemblyInfrastructureConnectorCreator> withProvidingAssemblyContext(AssemblyContext context) {
        IllegalArgumentException.throwIfNull(context, "The given AssemblyContext must not be null.");
        return new InfrastructureProvidedRoleSelector<AssemblyInfrastructureConnectorCreator>((provContext, role) -> {
            this.providingContext = provContext;
            this.providedRole = role;
            return this;
        }, context);
    }

    public InfrastructureProvidedRoleSelector<AssemblyInfrastructureConnectorCreator> withProvidingAssemblyContext(String name) {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withProvidingAssemblyContext(context);
    }

    public AssemblyInfrastructureConnector build() {
        AssemblyInfrastructureConnector connector = CompositionFactory.eINSTANCE.createAssemblyInfrastructureConnector();
        if (this.name != null) {
            connector.setEntityName(this.name);
        }
        connector.setRequiringAssemblyContext__AssemblyInfrastructureConnector(this.requiringContext);
        connector.setRequiredRole__AssemblyInfrastructureConnector(this.requiredRole);
        connector.setProvidingAssemblyContext__AssemblyInfrastructureConnector(this.providingContext);
        connector.setProvidedRole__AssemblyInfrastructureConnector(this.providedRole);
        return connector;
    }

    @Override
    public AssemblyInfrastructureConnectorCreator withName(String name) {
        return (AssemblyInfrastructureConnectorCreator)super.withName(name);
    }
}

