/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.qos;

import java.util.ArrayList;
import java.util.Collection;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.SystemEntity;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.qosannotations.QosannotationsFactory;
import org.palladiosimulator.pcm.qosannotations.SpecifiedOutputParameterAbstraction;
import org.palladiosimulator.pcm.qosannotations.SpecifiedQoSAnnotation;

public class QoSAnnotationsCreator
extends SystemEntity {
    private final Collection<SpecifiedOutputParameterAbstraction> outputParameterAbstractions = new ArrayList<SpecifiedOutputParameterAbstraction>();
    private final Collection<SpecifiedQoSAnnotation> qoSAnnotations = new ArrayList<SpecifiedQoSAnnotation>();

    public QoSAnnotationsCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public QoSAnnotationsCreator addQoSAnnotation(SpecifiedQoSAnnotation annotation) {
        this.qoSAnnotations.add(annotation);
        return this;
    }

    public QoSAnnotationsCreator addQoSAnnotations(Collection<SpecifiedQoSAnnotation> annotations) {
        this.qoSAnnotations.addAll(annotations);
        return this;
    }

    public QoSAnnotationsCreator addOutputParameterAbstraction(SpecifiedOutputParameterAbstraction outputParameterAbstraction) {
        this.outputParameterAbstractions.add(outputParameterAbstraction);
        return this;
    }

    public QoSAnnotationsCreator addOutputParameterAbstractions(Collection<SpecifiedOutputParameterAbstraction> outputParameterAbstractions) {
        this.outputParameterAbstractions.addAll(outputParameterAbstractions);
        return this;
    }

    public QoSAnnotations build() {
        QoSAnnotations annotations = QosannotationsFactory.eINSTANCE.createQoSAnnotations();
        if (this.name != null) {
            annotations.setEntityName(this.name);
        }
        annotations.getSpecifiedOutputParameterAbstractions_QoSAnnotations().addAll(this.outputParameterAbstractions);
        annotations.getSpecifiedQoSAnnotations_QoSAnnotations().addAll(this.qoSAnnotations);
        return annotations;
    }

    @Override
    public QoSAnnotationsCreator withName(String name) {
        return (QoSAnnotationsCreator)super.withName(name);
    }
}

