/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.role;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.SystemEntity;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.RepositoryFactory;

public class InfrastructureRequiredRoleCreator
extends SystemEntity {
    private InfrastructureInterface requiredInterface;

    public InfrastructureRequiredRoleCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public InfrastructureRequiredRoleCreator withRequiredInterface(InfrastructureInterface infrastructureInterface) {
        IllegalArgumentException.throwIfNull(infrastructureInterface, "The given Interface must not be null.");
        this.requiredInterface = infrastructureInterface;
        return this;
    }

    public InfrastructureRequiredRoleCreator withRequiredInterface(String name) throws NoSuchElementException {
        InfrastructureInterface infrastructureInterface;
        try {
            infrastructureInterface = (InfrastructureInterface)this.system.getInterfaceByName(name);
        }
        catch (ClassCastException e) {
            throw new NoSuchElementException(String.format("An Interface with name '%s' was found, but it was not an InfrastructureInterface. Please make sure all names are unique.", name), e);
        }
        return this.withRequiredInterface(infrastructureInterface);
    }

    public InfrastructureRequiredRole build() {
        InfrastructureRequiredRole role = RepositoryFactory.eINSTANCE.createInfrastructureRequiredRole();
        if (this.name != null) {
            role.setEntityName(this.name);
        }
        role.setRequiredInterface__InfrastructureRequiredRole(this.requiredInterface);
        return role;
    }

    @Override
    public InfrastructureRequiredRoleCreator withName(String name) {
        return (InfrastructureRequiredRoleCreator)super.withName(name);
    }
}

