/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.confidentiality.context.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Category implements Enumerator
{
    SUBJECT(0, "SUBJECT", "SUBJECT"),
    RESOURCE(1, "RESOURCE", "RESOURCE"),
    ENVIRONMENT(2, "ENVIRONMENT", "ENVIRONMENT"),
    ACTION(3, "ACTION", "ACTION");

    public static final int SUBJECT_VALUE = 0;
    public static final int RESOURCE_VALUE = 1;
    public static final int ENVIRONMENT_VALUE = 2;
    public static final int ACTION_VALUE = 3;
    private static final Category[] VALUES_ARRAY;
    public static final List<Category> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Category[]{SUBJECT, RESOURCE, ENVIRONMENT, ACTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Category get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Category result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Category getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Category result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Category get(int value) {
        switch (value) {
            case 0: {
                return SUBJECT;
            }
            case 1: {
                return RESOURCE;
            }
            case 2: {
                return ENVIRONMENT;
            }
            case 3: {
                return ACTION;
            }
        }
        return null;
    }

    private Category(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

