/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.core.composition.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.subsystem.SubSystem;

public final class ComposedStructureValidationUtil {
    private ComposedStructureValidationUtil() {
    }

    public static boolean validateSameSubsystemMustNotBeInstantiatedMoreThanOnce(ComposedStructure composedStructure) {
        try {
            return !ComposedStructureValidationUtil.isSameSubsystemInstantiatedMoreThanOnce(composedStructure);
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    private static boolean isSameSubsystemInstantiatedMoreThanOnce(ComposedStructure composedStructure) {
        Collection<SubSystem> instantiatedSubsystems = ComposedStructureValidationUtil.getInstantiatedSubsystems(composedStructure);
        HashSet<SubSystem> uniqueInstantiatedSubsystems = new HashSet<SubSystem>(instantiatedSubsystems);
        return instantiatedSubsystems.size() != uniqueInstantiatedSubsystems.size();
    }

    private static Collection<SubSystem> getInstantiatedSubsystems(ComposedStructure composedStructure) {
        Collection<AssemblyContext> assemblyContexts = ComposedStructureValidationUtil.getContainedAssemblyContexts(composedStructure, Collections.emptySet());
        return assemblyContexts.stream().map(AssemblyContext::getEncapsulatedComponent__AssemblyContext).filter(SubSystem.class::isInstance).map(SubSystem.class::cast).collect(Collectors.toList());
    }

    private static Collection<AssemblyContext> getContainedAssemblyContexts(ComposedStructure composedStructure, Set<ComposedStructure> visitedComponents) {
        ArrayList<AssemblyContext> result = new ArrayList<AssemblyContext>();
        if (visitedComponents.contains(composedStructure)) {
            throw new IllegalStateException("There is a cyclic instantiation!");
        }
        HashSet<ComposedStructure> newVisitedComponents = new HashSet<ComposedStructure>(visitedComponents);
        newVisitedComponents.add(composedStructure);
        for (AssemblyContext containedAc : composedStructure.getAssemblyContexts__ComposedStructure()) {
            result.add(containedAc);
            result.addAll(ComposedStructureValidationUtil.getContainedAssemblyContexts(containedAc, newVisitedComponents));
        }
        return result;
    }

    private static Collection<AssemblyContext> getContainedAssemblyContexts(AssemblyContext ac, Set<ComposedStructure> visitedComponents) {
        RepositoryComponent component = ac.getEncapsulatedComponent__AssemblyContext();
        if (component instanceof ComposedStructure) {
            return ComposedStructureValidationUtil.getContainedAssemblyContexts((ComposedStructure)((Object)component), visitedComponents);
        }
        return Collections.emptyList();
    }
}

