/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.repository;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ComponentType implements Enumerator
{
    BUSINESS_COMPONENT(0, "BUSINESS_COMPONENT", "BUSINESS_COMPONENT"),
    INFRASTRUCTURE_COMPONENT(1, "INFRASTRUCTURE_COMPONENT", "INFRASTRUCTURE_COMPONENT");

    public static final String copyright = "Copyright 2005-2017 by palladiosimulator.org";
    public static final int BUSINESS_COMPONENT_VALUE = 0;
    public static final int INFRASTRUCTURE_COMPONENT_VALUE = 1;
    private static final ComponentType[] VALUES_ARRAY;
    public static final List<ComponentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ComponentType[]{BUSINESS_COMPONENT, INFRASTRUCTURE_COMPONENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ComponentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComponentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComponentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComponentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComponentType get(int value) {
        switch (value) {
            case 0: {
                return BUSINESS_COMPONENT;
            }
            case 1: {
                return INFRASTRUCTURE_COMPONENT;
            }
        }
        return null;
    }

    private ComponentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

