/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.commonalities;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.palladiosimulator.retriever.extraction.commonalities.HTTPMethod;
import org.palladiosimulator.retriever.extraction.commonalities.Name;
import org.palladiosimulator.retriever.extraction.commonalities.OperationName;
import org.palladiosimulator.retriever.extraction.commonalities.RESTName;

public class RESTOperationName
implements OperationName {
    private RESTName restName;
    private final Set<HTTPMethod> httpMethods;

    public RESTOperationName(String host, String path, Set<HTTPMethod> httpMethods) throws IllegalArgumentException {
        this(new RESTName(host, path), httpMethods);
    }

    public RESTOperationName(String host, String path, HTTPMethod ... httpMethods) throws IllegalArgumentException {
        this(host, path, Set.of(httpMethods));
    }

    private RESTOperationName(RESTName restName, Set<HTTPMethod> httpMethods) {
        this.restName = restName;
        this.httpMethods = httpMethods.isEmpty() ? Set.of(HTTPMethod.WILDCARD) : Collections.unmodifiableSet(httpMethods);
    }

    @Override
    public String getInterface() {
        return this.toString();
    }

    @Override
    public Optional<String> forInterface(String baseInterface) {
        if (!this.isPartOf(baseInterface)) {
            return Optional.empty();
        }
        return Optional.of(this.getInterface());
    }

    @Override
    public List<String> getInterfaces() {
        return this.restName.getInterfaces();
    }

    @Override
    public Name createName(String name) {
        return RESTOperationName.parse(name).orElseThrow();
    }

    public String toString() {
        String pathString = this.restName.toString();
        if (this.httpMethods.isEmpty() || HTTPMethod.areAllPresent(this.httpMethods)) {
            return pathString;
        }
        String httpMethodString = "";
        List httpMethodNames = this.httpMethods.stream().map(Enum::toString).sorted().collect(Collectors.toList());
        httpMethodString = "[";
        httpMethodString = String.valueOf(httpMethodString) + String.join((CharSequence)",", httpMethodNames);
        httpMethodString = String.valueOf(httpMethodString) + "]";
        return String.valueOf(pathString) + httpMethodString;
    }

    public int hashCode() {
        return Objects.hash(this.restName, this.httpMethods);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RESTOperationName other = (RESTOperationName)obj;
        return Objects.equals(this.restName, other.restName) && Objects.equals(this.httpMethods, other.httpMethods);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Optional<String> getCommonInterface(Name other) {
        void var3_2;
        RESTOperationName rESTOperationName;
        Name name = other;
        if (name instanceof RESTOperationName && (rESTOperationName = (RESTOperationName)name) == (RESTOperationName)var3_2) {
            void otherREST;
            if (this.restName.equals(otherREST.restName)) {
                HashSet<HTTPMethod> httpMethodUnion = new HashSet<HTTPMethod>(this.httpMethods);
                httpMethodUnion.addAll(otherREST.httpMethods);
                return Optional.of(new RESTOperationName(this.restName, httpMethodUnion).toString());
            }
            return this.restName.getCommonInterface(otherREST.restName);
        }
        return OperationName.super.getCommonInterface(other);
    }

    @Override
    public boolean isPartOf(String iface) {
        if (RESTName.parse(iface).isPresent()) {
            return this.restName.isPartOf(iface);
        }
        Optional<RESTOperationName> parsedIface = RESTOperationName.parse(iface);
        if (parsedIface.isEmpty()) {
            return false;
        }
        RESTOperationName restIface = parsedIface.get();
        if (!this.restName.equals(restIface.restName)) {
            return false;
        }
        HashSet<HTTPMethod> normalHttpMethods = new HashSet<HTTPMethod>(this.httpMethods);
        normalHttpMethods.remove((Object)HTTPMethod.WILDCARD);
        return restIface.httpMethods.contains((Object)HTTPMethod.WILDCARD) || restIface.httpMethods.containsAll(this.httpMethods);
    }

    public static Optional<RESTOperationName> parse(String iface) {
        String[] parts = iface.split("\\[");
        Optional<RESTName> restNameOption = RESTName.parse(parts[0]);
        if (restNameOption.isEmpty()) {
            return Optional.empty();
        }
        Set<HTTPMethod> httpMethods = Set.of(HTTPMethod.WILDCARD);
        if (parts.length > 1) {
            int end = parts[1].lastIndexOf(93);
            String httpMethodNames = parts[1].substring(0, end);
            httpMethods = Stream.of(httpMethodNames.split(",")).map(HTTPMethod::valueOf).collect(Collectors.toSet());
        }
        return Optional.of(new RESTOperationName(restNameOption.get(), httpMethods));
    }
}

