/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.commonalities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import org.palladiosimulator.retriever.extraction.commonalities.EntireInterface;
import org.palladiosimulator.retriever.extraction.commonalities.Name;
import org.palladiosimulator.retriever.extraction.commonalities.OperationInterface;
import org.palladiosimulator.retriever.extraction.commonalities.RESTOperationName;
import org.palladiosimulator.retriever.extraction.commonalities.RESTOperationUnion;

public final class DependencyUtils {
    private DependencyUtils() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends OperationInterface> Map<OperationInterface, List<OperationInterface>> groupDependencies(Collection<T> dependencies, Collection<OperationInterface> allDependencies) {
        HashMap<OperationInterface, List<OperationInterface>> groupedDependencies = new HashMap<OperationInterface, List<OperationInterface>>();
        PriorityQueue<T> sortedDependencies = new PriorityQueue<T>(dependencies);
        while (!sortedDependencies.isEmpty()) {
            OperationInterface grouplessDependency = (OperationInterface)sortedDependencies.poll();
            boolean isRoot = true;
            for (OperationInterface rootInterface : groupedDependencies.keySet()) {
                if (!grouplessDependency.isPartOf(rootInterface)) continue;
                ((List)groupedDependencies.get(rootInterface)).add(grouplessDependency);
                isRoot = false;
                break;
            }
            if (isRoot) {
                for (OperationInterface rootInterface : groupedDependencies.keySet()) {
                    void restName;
                    RESTOperationName rESTOperationName;
                    Optional<String> commonName = grouplessDependency.getName().getCommonInterface(rootInterface.getName());
                    boolean containsOtherDependency = false;
                    if (!commonName.isPresent()) continue;
                    Name commonInterfaceName = rootInterface.getName().createName(commonName.get());
                    Name name = commonInterfaceName;
                    OperationInterface commonInterface = name instanceof RESTOperationName && (rESTOperationName = (RESTOperationName)name) == (RESTOperationName)name ? new RESTOperationUnion((RESTOperationName)restName) : new EntireInterface(commonInterfaceName);
                    for (OperationInterface dependency : allDependencies) {
                        if (dependencies.contains(dependency)) continue;
                        containsOtherDependency |= dependency.isPartOf(commonInterface) && !commonInterface.isPartOf(dependency);
                    }
                    if (containsOtherDependency) continue;
                    HashSet<OperationInterface> interfaces = new HashSet<OperationInterface>((Collection)groupedDependencies.remove(rootInterface));
                    if (!(commonInterface instanceof RESTOperationUnion)) {
                        interfaces.add(commonInterface);
                    }
                    if (!(rootInterface instanceof RESTOperationUnion)) {
                        interfaces.add(rootInterface);
                    }
                    interfaces.add(grouplessDependency);
                    groupedDependencies.put(commonInterface, new ArrayList(interfaces));
                    isRoot = false;
                    break;
                }
            }
            if (!isRoot) continue;
            groupedDependencies.put(grouplessDependency, new LinkedList());
            ((List)groupedDependencies.get(grouplessDependency)).add(grouplessDependency);
        }
        return groupedDependencies;
    }
}

