/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.commonalities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.retriever.extraction.commonalities.DependencyUtils;
import org.palladiosimulator.retriever.extraction.commonalities.Operation;
import org.palladiosimulator.retriever.extraction.commonalities.OperationInterface;
import org.palladiosimulator.retriever.extraction.engine.MapMerger;

public class Provisions
implements Iterable<OperationInterface> {
    private final Set<OperationInterface> provisions;
    private final Map<OperationInterface, List<OperationInterface>> groupedProvisions;

    public Provisions(Collection<OperationInterface> provisions, Collection<OperationInterface> allDependencies) {
        this.provisions = Collections.unmodifiableSet(new HashSet<OperationInterface>(provisions));
        this.groupedProvisions = DependencyUtils.groupDependencies(provisions, allDependencies);
    }

    public Set<OperationInterface> get() {
        return this.provisions;
    }

    public Map<OperationInterface, List<OperationInterface>> getGrouped() {
        return this.groupedProvisions;
    }

    public boolean containsPartOf(OperationInterface iface) {
        return this.provisions.stream().anyMatch(x -> x.isPartOf(iface));
    }

    public boolean containsEntire(OperationInterface iface) {
        return this.provisions.stream().anyMatch(x -> iface.isPartOf((OperationInterface)x));
    }

    @Override
    public Iterator<OperationInterface> iterator() {
        return this.provisions.iterator();
    }

    public Map<OperationInterface, Set<Operation>> simplified() {
        LinkedList simplifiedInterfaces = new LinkedList();
        for (OperationInterface root : this.groupedProvisions.keySet()) {
            ArrayList simplifiedRoot = new ArrayList(root.simplified().values().stream().flatMap(x -> x.stream()).collect(Collectors.toList()));
            for (OperationInterface member : this.groupedProvisions.get(root)) {
                simplifiedRoot.addAll(member.simplified().values().stream().flatMap(x -> x.stream()).collect(Collectors.toList()));
            }
            simplifiedInterfaces.add(Map.of(root, (Set)simplifiedRoot.stream().distinct().collect(Collectors.toCollection(HashSet::new))));
        }
        return MapMerger.merge(simplifiedInterfaces);
    }

    public int hashCode() {
        return Objects.hash(this.provisions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Provisions other = (Provisions)obj;
        return Objects.equals(this.provisions, other.provisions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Map<OperationInterface, Set<Operation>> simplified = this.simplified();
        for (OperationInterface iface : simplified.keySet()) {
            builder.append(iface.getName());
            simplified.get(iface).forEach(x -> {
                StringBuilder stringBuilder2 = builder.append("\n\t").append(x);
            });
            builder.append('\n');
        }
        String result = builder.toString();
        if (result.endsWith("\n")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

