/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.commonalities;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.palladiosimulator.retriever.extraction.commonalities.OperationInterface;
import org.palladiosimulator.retriever.extraction.commonalities.Requirements;

public class RequirementsBuilder {
    private final List<OperationInterface> requirements = new LinkedList<OperationInterface>();
    private final Set<OperationInterface> weakRequirements = new HashSet<OperationInterface>();

    public void add(OperationInterface ... interfaces) {
        this.add(List.of(interfaces));
    }

    public synchronized void add(Collection<OperationInterface> interfaces) {
        this.requirements.addAll(interfaces);
    }

    public synchronized void addWeakly(OperationInterface iface) {
        this.weakRequirements.add(iface);
    }

    public synchronized void strengthenIfPresent(OperationInterface iface) {
        if (this.weakRequirements.contains(iface)) {
            this.weakRequirements.remove(iface);
            this.requirements.add(iface);
        }
    }

    public synchronized boolean containsRelated(OperationInterface provision) {
        boolean entirelyRequired;
        boolean partlyRequired;
        for (OperationInterface requirement : this.requirements) {
            partlyRequired = requirement.isPartOf(provision);
            entirelyRequired = provision.isPartOf(requirement);
            if (!partlyRequired && !entirelyRequired) continue;
            return true;
        }
        for (OperationInterface requirement : this.weakRequirements) {
            partlyRequired = requirement.isPartOf(provision);
            entirelyRequired = provision.isPartOf(requirement);
            if (!partlyRequired && !entirelyRequired) continue;
            return true;
        }
        return false;
    }

    public Requirements create(Collection<OperationInterface> allDependencies, Collection<OperationInterface> visibleProvisions) {
        return new Requirements(this.requirements, allDependencies, visibleProvisions);
    }

    public List<OperationInterface> toList() {
        return Collections.unmodifiableList(this.requirements);
    }

    public int hashCode() {
        return Objects.hash(this.requirements, this.weakRequirements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RequirementsBuilder other = (RequirementsBuilder)obj;
        return Objects.equals(this.requirements, other.requirements) && Objects.equals(this.weakRequirements, other.weakRequirements);
    }
}

