/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.mocore.transformation;

import org.palladiosimulator.generator.fluent.system.api.ISystemAddition;
import org.palladiosimulator.generator.fluent.system.factory.FluentSystemFactory;
import org.palladiosimulator.generator.fluent.system.structure.AssemblyContextCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.operation.AssemblyConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.operation.ProvidedDelegationConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.role.OperationProvidedRoleCreator;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.retriever.mocore.surrogate.PcmSurrogate;
import org.palladiosimulator.retriever.mocore.surrogate.element.Component;
import org.palladiosimulator.retriever.mocore.surrogate.element.Interface;
import org.palladiosimulator.retriever.mocore.surrogate.relation.ComponentAssemblyRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.CompositionRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.InterfaceProvisionRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.InterfaceRequirementRelation;
import org.palladiosimulator.retriever.mocore.transformation.RepositoryTransformer;
import tools.mdsd.mocore.framework.surrogate.Relation;
import tools.mdsd.mocore.framework.transformation.Transformer;

public class SystemTransformer
implements Transformer<PcmSurrogate, System> {
    private static final String ASSEMBLY_CONTEXT_NAME_PATTERN = "%s Assembly Context";
    private static final String ASSEMBLY_CONNECTOR_NAME_PATTERN = "%s Connector";
    private static final String DELEGATION_ROLE_NAME_PATTERN = "%s Delegation-Provider";
    private static final String DELEGATION_CONNECTOR_NAME_PATTERN = "%s Delegation Connector";

    public System transform(PcmSurrogate model) {
        Repository repository = new RepositoryTransformer().transform(model);
        return this.transform(model, repository);
    }

    public System transform(PcmSurrogate model, Repository repository) {
        FluentSystemFactory systemFactory = new FluentSystemFactory();
        ISystemAddition fluentSystem = systemFactory.newSystem().addRepository(repository);
        for (Component component : model.getByType(Component.class)) {
            AssemblyContextCreator contextCreator = this.getAssemblyContextCreator(systemFactory, component);
            fluentSystem.addToSystem(contextCreator);
        }
        for (Relation relation : model.getByType(ComponentAssemblyRelation.class)) {
            AssemblyConnectorCreator connectorCreator = this.getAssemblyConnectorCreator(systemFactory, (ComponentAssemblyRelation)relation);
            fluentSystem.addToSystem((AbstractConnectorCreator)connectorCreator);
        }
        for (Relation relation : model.getByType(InterfaceProvisionRelation.class)) {
            Interface providedInteface = (Interface)relation.getDestination();
            String providedIntefaceName = ((OperationInterface)providedInteface.getValue()).getEntityName();
            Component provider = (Component)relation.getSource();
            boolean existsRequirement = model.getByType(InterfaceRequirementRelation.class).stream().anyMatch(requirementRelation -> ((Interface)requirementRelation.getDestination()).equals((Object)providedInteface));
            boolean isCompositeChild = model.getByType(CompositionRelation.class).stream().anyMatch(composition -> ((Component)composition.getDestination()).equals((Object)provider));
            boolean excludeDelegation = RepositoryTransformer.isExcludedFromDelegation(provider, providedInteface);
            if (existsRequirement || isCompositeChild || excludeDelegation) continue;
            String delegationRoleName = String.format(DELEGATION_ROLE_NAME_PATTERN, providedIntefaceName);
            OperationProvidedRoleCreator systemProvidedRole = systemFactory.newOperationProvidedRole().withName(delegationRoleName).withProvidedInterface(providedIntefaceName);
            fluentSystem.addToSystem(systemProvidedRole);
            String delegationConnectorName = String.format(DELEGATION_CONNECTOR_NAME_PATTERN, providedIntefaceName);
            ProvidedDelegationConnectorCreator systemDelegation = (ProvidedDelegationConnectorCreator)systemFactory.newProvidedDelegationConnectorCreator().withName(delegationConnectorName).withOuterProvidedRole(delegationRoleName).withProvidingContext(SystemTransformer.getAssemblyContextName(provider)).withOperationProvidedRole(RepositoryTransformer.getProvidedRoleName(providedInteface));
            fluentSystem.addToSystem((AbstractConnectorCreator)systemDelegation);
        }
        return fluentSystem.createSystemNow();
    }

    protected static String getAssemblyContextName(Component<?> component) {
        String componentEntityName = ((RepositoryComponent)component.getValue()).getEntityName();
        return String.format(ASSEMBLY_CONTEXT_NAME_PATTERN, componentEntityName);
    }

    protected static String getAssemblyConnectorName(Interface interfaceInstance) {
        String interfaceEntityName = ((OperationInterface)interfaceInstance.getValue()).getEntityName();
        return String.format(ASSEMBLY_CONNECTOR_NAME_PATTERN, interfaceEntityName);
    }

    private AssemblyContextCreator getAssemblyContextCreator(FluentSystemFactory fluentFactory, Component<?> component) {
        String componentEntityName = ((RepositoryComponent)component.getValue()).getEntityName();
        String assemblyContextName = SystemTransformer.getAssemblyContextName(component);
        AssemblyContextCreator contextCreator = fluentFactory.newAssemblyContext().withName(assemblyContextName).withEncapsulatedComponent(componentEntityName);
        return contextCreator;
    }

    private AssemblyConnectorCreator getAssemblyConnectorCreator(FluentSystemFactory fluentFactory, ComponentAssemblyRelation assemblyRelation) {
        Component provider = (Component)((InterfaceProvisionRelation)assemblyRelation.getSource()).getSource();
        Component consumer = (Component)((InterfaceRequirementRelation)assemblyRelation.getDestination()).getSource();
        Interface interfaceInstance = (Interface)((InterfaceProvisionRelation)assemblyRelation.getSource()).getDestination();
        String connectorName = SystemTransformer.getAssemblyConnectorName(interfaceInstance);
        String providerName = SystemTransformer.getAssemblyContextName(provider);
        String consumerName = SystemTransformer.getAssemblyContextName(consumer);
        String providedRoleName = RepositoryTransformer.getProvidedRoleName(interfaceInstance);
        String requiredRoleName = RepositoryTransformer.getRequiredRoleName(interfaceInstance);
        AssemblyConnectorCreator connectorCreator = (AssemblyConnectorCreator)((AssemblyConnectorCreator)fluentFactory.newAssemblyConnector().withName(connectorName).withProvidingAssemblyContext(providerName).withOperationProvidedRole(providedRoleName)).withRequiringAssemblyContext(consumerName).withOperationRequiredRole(requiredRoleName);
        return connectorCreator;
    }
}

